/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.FixVersionHistoryService;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.EstimatableIssueDataCallback;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.workingdays.WorkingDaysService;
import com.atlassian.greenhopper.web.rapid.chart.FixVersionChangeEntry;
import com.atlassian.greenhopper.web.rapid.chart.FlotChartUtils;
import com.atlassian.greenhopper.web.rapid.chart.ProgressChartData;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryDataService;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryEntry;
import com.atlassian.greenhopper.web.rapid.chart.VersionEntry;
import com.atlassian.greenhopper.web.rapid.chart.VersionEntryFactory;
import com.atlassian.greenhopper.web.rapid.chart.VersionProgressChartModel;
import com.atlassian.greenhopper.web.rapid.chart.WorkRateDataFactory;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChangeUtil;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownColumnChangeData;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownColumnChangeFactory;
import com.atlassian.greenhopper.web.rapid.chart.time.WorkRateData;
import com.atlassian.greenhopper.web.rapid.view.StatisticsFieldEntry;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionProgressChartModelFactory {
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private FixVersionHistoryService fixVersionHistoryService;
    @Autowired
    private StatisticHistoryDataService statisticHistoryDataService;
    @Autowired
    private BurndownColumnChangeFactory burndownColumnChangeFactory;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private TimeZoneManager timeZoneManager;
    @Autowired
    private WorkRateDataFactory workRateDataFactory;
    @Autowired
    private VersionEntryFactory versionEntryFactory;
    @Autowired
    private WorkingDaysService workingDaysService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private IssueDataService issueDataService;

    public ServiceOutcome<VersionProgressChartModel> getVersionProgressChartModel(ApplicationUser user, RapidView rapidView, Version version) {
        ServiceOutcome<StatisticsField> statisticsField = this.estimateStatisticService.getEstimateStatisticStrict(rapidView);
        if (!statisticsField.isValid()) {
            return ServiceOutcomeImpl.error(statisticsField);
        }
        DateTime now = new DateTime(DateTimeZone.UTC);
        ServiceOutcome<ProgressChartData<FixVersionChangeEntry>> data = this.getScopeChangeModelDataForVersion(user, rapidView, version, statisticsField.getValue(), now);
        if (!data.isValid()) {
            return ServiceOutcomeImpl.error(data);
        }
        return this.constructVersionProgressModel(user, rapidView, version, data.getValue(), now);
    }

    private ServiceOutcome<ProgressChartData<FixVersionChangeEntry>> getScopeChangeModelDataForVersion(ApplicationUser user, RapidView rapidView, Version version, StatisticsField statisticsField, DateTime now) {
        ServiceOutcome<Query> queryResult = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (queryResult.isInvalid()) {
            return ServiceOutcomeImpl.error(queryResult);
        }
        Query query = JqlQueryBuilder.newBuilder((Query)queryResult.getValue()).where().defaultAnd().issueTypeIsStandard().endWhere().buildQuery();
        ServiceOutcome<Map<String, List<FixVersionChangeEntry>>> versionHistoryOutcome = this.fixVersionHistoryService.findVersionHistory(user, query, version.getId());
        if (!versionHistoryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(versionHistoryOutcome);
        }
        Set<String> issueKeys = versionHistoryOutcome.getValue().keySet();
        EstimatableIssueDataCallback estimatableIssueDataCallback = new EstimatableIssueDataCallback(this.estimateStatisticService, statisticsField, (Option<Set<String>>)Option.option(issueKeys));
        ServiceOutcome<Void> findOutcome = this.issueDataService.find(user, query, estimatableIssueDataCallback);
        if (findOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(findOutcome);
        }
        Set<String> estimatableIssueKeys = estimatableIssueDataCallback.getEstimatableIssueKeys();
        ServiceOutcome<Map<String, List<StatisticHistoryEntry>>> statisticsValueHistoryOutcome = this.statisticHistoryDataService.getStatisticHistory(user, issueKeys, statisticsField, now);
        if (!statisticsValueHistoryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(statisticsValueHistoryOutcome);
        }
        ServiceOutcome<BurndownColumnChangeData> columnChangeData = this.burndownColumnChangeFactory.getBurndownColumnChangeData(user, rapidView, issueKeys);
        if (!columnChangeData.isValid()) {
            return ServiceOutcomeImpl.error(columnChangeData);
        }
        return ServiceOutcomeImpl.ok(new ProgressChartData(columnChangeData.getValue().getColumns(), versionHistoryOutcome.getValue(), statisticsValueHistoryOutcome.getValue(), estimatableIssueKeys, statisticsField, columnChangeData.getValue().getColumnChanges()));
    }

    private ServiceOutcome<VersionProgressChartModel> constructVersionProgressModel(ApplicationUser user, RapidView rapidView, Version version, ProgressChartData data, DateTime now) {
        ServiceOutcome<WorkRateData> workRateData;
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        TimeZone userTimeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        ServiceOutcome<WorkingDaysConfig> workingDaysConfigurationOutcome = this.workingDaysService.getWorkingDaysConfiguration(user, rapidView);
        if (workingDaysConfigurationOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(workingDaysConfigurationOutcome);
        }
        DateTimeZone boardDateTimeZone = this.workingDaysService.getDateTimeZone(workingDaysConfigurationOutcome.getValue());
        DateTime startDate = this.getStartDate(now, data.getHistory());
        DateTime endDate = new DateTime((Object)now);
        VersionProgressChartModel model = new VersionProgressChartModel();
        ServiceOutcome<VersionEntry> versionEntry = this.versionEntryFactory.constructVersionEntry(version, userTimeZone, boardDateTimeZone);
        if (!versionEntry.isValid()) {
            return ServiceOutcomeImpl.error(versionEntry);
        }
        model.projectKey = version.getProjectObject().getKey();
        model.version = versionEntry.getValue();
        model.startTime = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, startDate.getMillis());
        model.estimatableIssueKeys = data.getEstimatableIssueKeys();
        model.statisticField = StatisticsFieldEntry.create(data.getStatisticField(), i18n);
        model.now = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, now);
        Map<String, List<BurndownChange>> changesPerIssue = this.getChangesForVersion(startDate, now, data);
        model.changes = BurndownChangeUtil.transformChangesToTimeline(userTimeZone, changesPerIssue);
        DateTime startWorkRateData = new DateTime((Object)model.startTime);
        if (startWorkRateData.isAfter((ReadableInstant)startDate)) {
            startWorkRateData = startDate;
        }
        if (startWorkRateData.isAfter((ReadableInstant)endDate)) {
            endDate = startWorkRateData.toDateTime();
        }
        if (!(workRateData = this.workRateDataFactory.getWorkRateData(user, rapidView, userTimeZone, startWorkRateData, endDate)).isValid()) {
            return ServiceOutcomeImpl.error(workRateData);
        }
        model.workRateData = workRateData.getValue();
        return ServiceOutcomeImpl.ok(model);
    }

    private Map<String, List<BurndownChange>> getChangesForVersion(DateTime startDate, DateTime now, ProgressChartData<FixVersionChangeEntry> data) {
        HashMap<String, List<BurndownChange>> changes = new HashMap<String, List<BurndownChange>>();
        Map<String, List<FixVersionChangeEntry>> history = data.getHistory();
        BurndownChangeUtil.addVersionHistoryChanges(history, changes);
        BurndownChangeUtil.addStatisticsValueChanges(startDate, now, data.getStatisticsValueHistory(), changes);
        BurndownChangeUtil.addColumnChanges(startDate, now, data.getColumnChanges(), changes, false);
        BurndownChangeUtil.optimizeBurndownChanges(changes);
        return changes;
    }

    private DateTime getStartDate(DateTime now, Map<String, List<FixVersionChangeEntry>> history) {
        DateTime startDate = new DateTime((Object)now);
        for (List<FixVersionChangeEntry> fixVersionChangeEntries : history.values()) {
            for (FixVersionChangeEntry entry : fixVersionChangeEntries) {
                if (!entry.date.isBefore((ReadableInstant)startDate)) continue;
                startDate = entry.date;
            }
        }
        return startDate;
    }
}

