/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.project.version.VersionMetaData;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.version.VersionService;
import com.atlassian.greenhopper.web.rapid.chart.FlotChartUtils;
import com.atlassian.greenhopper.web.rapid.chart.VersionEntry;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.project.version.Version;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionEntryFactory {
    @Autowired
    private JqlStringSupport jqlStringSupport;
    @Autowired
    private VersionService versionService;
    @Autowired
    private DateTimeFormatter dateTimeFormatter;

    public ServiceOutcome<VersionEntry> constructVersionEntry(Version version, TimeZone userTimeZone, DateTimeZone boardTimeZone) {
        Date releaseDate;
        VersionMetaData versionMetaData = this.versionService.getMetaData(version);
        VersionEntry entry = new VersionEntry();
        Date startDate = versionMetaData.getStartDate();
        if (startDate != null) {
            DateTime boardStartDateTime = VersionEntryFactory.convertJvmDateToBoardDateTime(startDate, boardTimeZone, 0, 0);
            entry.startDate = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, boardStartDateTime);
            entry.startTimeOffset = VersionEntryFactory.formatTimeZoneOffset(boardTimeZone, boardStartDateTime);
            entry.formattedStartDate = this.formatDate(startDate);
        }
        if ((releaseDate = version.getReleaseDate()) != null) {
            DateTime boardReleaseDateTime = VersionEntryFactory.convertJvmDateToBoardDateTime(releaseDate, boardTimeZone, 23, 59);
            entry.releaseDate = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, boardReleaseDateTime);
            entry.releaseTimeOffset = VersionEntryFactory.formatTimeZoneOffset(boardTimeZone, boardReleaseDateTime);
            entry.formattedReleaseDate = this.formatDate(releaseDate);
        }
        entry.description = version.getDescription();
        entry.name = version.getName();
        entry.id = version.getId();
        entry.projectKey = version.getProjectObject().getKey();
        entry.released = version.isReleased();
        entry.jqlEncodedName = this.jqlStringSupport.encodeValue(entry.name);
        if (version.isReleased()) {
            entry.released = true;
        }
        return ServiceOutcomeImpl.ok(entry);
    }

    static DateTime convertJvmDateToBoardDateTime(Date versionDate, DateTimeZone boardTimeZone, int hourOfDay, int minuteOfHour) {
        DateTime jvmReleaseDateTime = new DateTime(versionDate.getTime());
        return new DateTime(jvmReleaseDateTime.getYear(), jvmReleaseDateTime.getMonthOfYear(), jvmReleaseDateTime.getDayOfMonth(), hourOfDay, minuteOfHour, boardTimeZone);
    }

    public static String formatTimeZoneOffset(DateTimeZone boardTimeZone, DateTime date) {
        org.joda.time.format.DateTimeFormatter timeZoneFormatter = DateTimeFormat.forPattern((String)"ZZ").withZone(boardTimeZone);
        return "GMT" + timeZoneFormatter.print((ReadableInstant)date);
    }

    private String formatDate(Date date) {
        return this.dateTimeFormatter.withStyle(DateTimeStyle.DATE).format(date);
    }
}

