/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.web.rapid.chart.EstimateValue;
import com.atlassian.greenhopper.web.rapid.chart.VelocityChartModel;
import com.atlassian.greenhopper.web.rapid.issue.statistics.HistoricalEstimateStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueSprintStatistics;
import java.util.Set;

public class VelocityStatEntryFactory {
    private final Set<String> issueKeys;
    private final HistoricalEstimateStatisticValueResolver historicalEstimateStatisticValueResolver;

    public VelocityStatEntryFactory(Set<String> issueKeys, HistoricalEstimateStatisticValueResolver valueResolver) {
        if (issueKeys == null || valueResolver == null) {
            throw new IllegalArgumentException("Either the list of issue keys or historical estimate statistic value resolver can not be null");
        }
        this.issueKeys = issueKeys;
        this.historicalEstimateStatisticValueResolver = valueResolver;
    }

    public VelocityChartModel.VelocityStatEntry getVelocityStatEntry() {
        EstimateValue committed = new EstimateValue();
        EstimateValue completed = new EstimateValue();
        for (String issueKey : this.issueKeys) {
            IssueSprintStatistics issueSprintStatistics = this.historicalEstimateStatisticValueResolver.getIssueSprintStatistics(issueKey);
            this.addToCommittedValue(committed, issueKey, issueSprintStatistics);
            this.addToCompletedValue(completed, issueKey, issueSprintStatistics);
        }
        return new VelocityChartModel.VelocityStatEntry(committed.getDoubleValue(), completed.getDoubleValue());
    }

    private void addToCompletedValue(EstimateValue completed, String issueKey, IssueSprintStatistics issueSprintStatistics) {
        if (issueSprintStatistics.wasIssueCompletedInTheCurrentSprint) {
            Double estimatedValue = this.historicalEstimateStatisticValueResolver.getCurrentEstimation(issueKey);
            completed.add(estimatedValue);
        }
    }

    private void addToCommittedValue(EstimateValue committed, String issueKey, IssueSprintStatistics issueSprintStatistics) {
        if (!issueSprintStatistics.wasIssueAddedDuringSprint) {
            Double estimatedValue = this.historicalEstimateStatisticValueResolver.getValue(issueKey);
            committed.add(estimatedValue);
        }
    }
}

