/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintQueryService;
import com.atlassian.greenhopper.web.rapid.chart.SprintBurndownModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.VelocityChartModel;
import com.atlassian.greenhopper.web.rapid.chart.VelocityStatEntryFactory;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.issue.statistics.HistoricalEstimateStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.StatisticValueResolverFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintBaseEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VelocityChartModelFactory {
    private static final int NUM_SPRINTS = 7;
    @Autowired
    private SprintBurndownModelFactory sprintBurndownModelFactory;
    @Autowired
    private StatisticValueResolverFactory statisticValueResolverFactory;
    @Autowired
    private SprintQueryService sprintQueryService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private SprintEntryFactory sprintEntryFactory;

    public ServiceOutcome<VelocityChartModel> getVelocityChartModel(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        ServiceOutcome<StatisticsField> estimateStatistic = this.estimateStatisticService.getEstimateStatisticStrict(rapidView);
        if (!estimateStatistic.isValid()) {
            return ServiceOutcomeImpl.error(estimateStatistic);
        }
        ServiceOutcome<List<Sprint>> sprints = this.sprintQueryService.getClosedSprints(user, rapidViewQuery.getValue());
        if (!sprints.isValid()) {
            return ServiceOutcomeImpl.error(sprints);
        }
        ArrayList mappedStatusIds = Lists.newArrayList((Iterable)Iterables.transform(this.columnService.getMappedStatuses(rapidView), (Function)new Function<Status, String>(){

            public String apply(Status from) {
                return from.getId();
            }
        }));
        List<Sprint> closedSprints = sprints.getValue();
        Collections.sort(closedSprints, new SprintComparator());
        VelocityChartModel model = new VelocityChartModel();
        int numSprints = closedSprints.size() > 7 ? 7 : closedSprints.size();
        for (Sprint sprint : closedSprints.subList(0, numSprints)) {
            ServiceOutcome<Map<String, List<BurndownChange>>> historyData = this.sprintBurndownModelFactory.getBurndownChangesForSprint(user, rapidView, sprint);
            if (!historyData.isValid()) {
                return ServiceOutcomeImpl.error(historyData);
            }
            HistoricalEstimateStatisticValueResolver valueResolver = this.statisticValueResolverFactory.forHistoricalEstimateStatisticValue(estimateStatistic.getValue(), sprint, historyData.getValue(), mappedStatusIds);
            model.sprints.add((SprintBaseEntry)this.sprintEntryFactory.newBaseTransformer(user).apply(sprint));
            VelocityStatEntryFactory velocityStatEntryFactory = new VelocityStatEntryFactory(historyData.getValue().keySet(), valueResolver);
            model.velocityStatEntries.put(sprint.getId(), velocityStatEntryFactory.getVelocityStatEntry());
        }
        return ServiceOutcomeImpl.ok(model);
    }

    public static class SprintComparator
    implements Comparator<Sprint> {
        @Override
        public int compare(Sprint o1, Sprint o2) {
            if (o2.getCompleteDate() == null && o1.getCompleteDate() == null) {
                return 0;
            }
            if (o2.getCompleteDate() == null && o1.getCompleteDate() != null) {
                return -1;
            }
            if (o2.getCompleteDate() != null && o1.getCompleteDate() == null) {
                return 1;
            }
            return o2.getCompleteDate().compareTo((ReadableInstant)o1.getCompleteDate());
        }
    }
}

