/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SwimlaneFilter {
    private static final SwimlaneFilter ALL_SWIMLANES = new SwimlaneFilter(true, Collections.emptyMap());
    private final boolean allSwimlanes;
    private final Set<String> includedIssueKeys;
    private final Map<String, Long> issuesInSwimlanes;

    public SwimlaneFilter(Map<String, Long> issuesInSwimlanes) {
        this(false, issuesInSwimlanes);
    }

    public SwimlaneFilter(boolean allSwimlanes, Map<String, Long> issuesInSwimlanes) {
        this.allSwimlanes = allSwimlanes;
        this.issuesInSwimlanes = issuesInSwimlanes;
        this.includedIssueKeys = issuesInSwimlanes.keySet();
    }

    public boolean includes(String issueKey) {
        return this.allSwimlanes || this.includedIssueKeys.contains(issueKey);
    }

    public Long getSwimlaneId(String issueKey) {
        return this.issuesInSwimlanes.get(issueKey);
    }

    public static SwimlaneFilter allSwimlanes() {
        return ALL_SWIMLANES;
    }
}

