/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.util.DateUtils;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryDataCallback;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryDataService;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryEntry;
import com.atlassian.greenhopper.web.rapid.issue.statistics.ChangeHistoryStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.StatisticValueResolverFactory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticHistoryDataServiceImpl
implements StatisticHistoryDataService {
    private static final int BATCH_SIZE = 500;
    @Autowired
    private OfBizDelegator ofBizDelegator;
    @Autowired
    private StatisticValueResolverFactory statisticValueResolverFactory;
    @Autowired
    private IssueDataService issueDataService;

    @Override
    public ServiceOutcome<Map<String, List<StatisticHistoryEntry>>> getStatisticHistory(ApplicationUser user, Collection<String> issueKeys, StatisticsField statisticField, DateTime sprintCompleteDate) {
        if (issueKeys.size() == 0) {
            return ServiceOutcomeImpl.ok(Collections.emptyMap());
        }
        ServiceOutcome<Set<StatisticHistoryDataCallback.BaseData>> baseData = this.getBaseData(user, issueKeys, statisticField);
        if (!baseData.isValid()) {
            return ServiceOutcomeImpl.error(baseData);
        }
        return this.getCompleteHistory(user, statisticField, baseData.getValue(), sprintCompleteDate);
    }

    private ServiceOutcome<Set<StatisticHistoryDataCallback.BaseData>> getBaseData(ApplicationUser user, Collection<String> issueKeys, StatisticsField statisticField) {
        StatisticHistoryDataCallback callback;
        DocumentStatisticValueResolver documentStatisticValueResolver = this.statisticValueResolverFactory.forEstimationStatisticInDocument(statisticField);
        Query query = JqlQueryBuilder.newBuilder().where().issue(issueKeys.toArray(new String[issueKeys.size()])).buildQuery();
        ServiceOutcome<Void> outcome = this.issueDataService.findWithServiceOutcome(user, query, callback = new StatisticHistoryDataCallback(documentStatisticValueResolver));
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok(callback.getBaseData());
    }

    private ServiceOutcome<Map<String, List<StatisticHistoryEntry>>> getCompleteHistory(ApplicationUser user, StatisticsField statisticField, Set<StatisticHistoryDataCallback.BaseData> baseDataForIssues, DateTime sprintCompleteDate) {
        List<Long> issueIds = this.extractIssueIds(baseDataForIssues);
        ChangeHistoryStatisticValueResolver changeHistoryStatisticValueResolver = this.statisticValueResolverFactory.forEstimationStatisticInChangeHistory(statisticField);
        Map<Object, Object> statisticEntriesInOrder = changeHistoryStatisticValueResolver.getChangeItemField() != null ? this.getChangeItemsForField(issueIds, changeHistoryStatisticValueResolver.getChangeItemField()) : Collections.emptyMap();
        HashMap result = new HashMap();
        for (StatisticHistoryDataCallback.BaseData baseData : baseDataForIssues) {
            SortedSet changes = statisticEntriesInOrder.containsKey(baseData.issueId) ? (SortedSet)statisticEntriesInOrder.get(baseData.issueId) : Collections.unmodifiableSortedSet(new TreeSet());
            ArrayList<StatisticHistoryEntry> history = new ArrayList<StatisticHistoryEntry>();
            if (changes.isEmpty()) {
                StatisticHistoryEntry entry = new StatisticHistoryEntry(baseData.createdDate, baseData.value);
                history.add(entry);
            } else {
                if (sprintCompleteDate != null) {
                    this.stripChangesAfterCompletionDate(changes, sprintCompleteDate);
                }
                boolean first = true;
                for (ChangeItemBean change : changes) {
                    if (first) {
                        Double oldValue = changeHistoryStatisticValueResolver.getChangeItemValue(change.getFrom(), change.getFromString());
                        StatisticHistoryEntry initialValue = new StatisticHistoryEntry(baseData.createdDate, oldValue);
                        history.add(initialValue);
                        first = false;
                    }
                    DateTime date = DateUtils.toDateTime(change.getCreated());
                    Double newValue = changeHistoryStatisticValueResolver.getChangeItemValue(change.getTo(), change.getToString());
                    StatisticHistoryEntry entry = new StatisticHistoryEntry(date, newValue);
                    history.add(entry);
                }
            }
            result.put(baseData.issueKey, history);
        }
        return ServiceOutcomeImpl.ok(result);
    }

    private void stripChangesAfterCompletionDate(SortedSet<ChangeItemBean> changes, DateTime sprintCompleteDate) {
        Iterator changeItemBeans = changes.iterator();
        Timestamp ts = new Timestamp(sprintCompleteDate.getMillis());
        while (changeItemBeans.hasNext()) {
            ChangeItemBean change = (ChangeItemBean)changeItemBeans.next();
            if (change.getCreated().compareTo(ts) < 0) continue;
            changeItemBeans.remove();
        }
    }

    private Map<Long, SortedSet<ChangeItemBean>> getChangeItemsForField(List<Long> allIssueIds, String changeItemFieldName) {
        Assertions.notBlank((String)"changeItemFieldName", (String)changeItemFieldName);
        LinkedHashMap<Long, SortedSet<ChangeItemBean>> result = new LinkedHashMap<Long, SortedSet<ChangeItemBean>>();
        int issueCount = allIssueIds.size();
        int batchNum = 0;
        int startIndex = 0;
        while (startIndex < issueCount) {
            int batchSize = Math.min(issueCount - startIndex, 500);
            List<Long> issueIds = allIssueIds.subList(startIndex, startIndex + batchSize);
            ArrayList<EntityExpr> conditionList = new ArrayList<EntityExpr>();
            conditionList.add(new EntityExpr("issue", EntityOperator.IN, issueIds));
            conditionList.add(new EntityExpr("field", EntityOperator.EQUALS, (Object)changeItemFieldName));
            EntityConditionList conditions = new EntityConditionList(conditionList, EntityOperator.AND);
            List changeItemsForFieldGVs = this.ofBizDelegator.findByCondition("ChangeGroupChangeItemView", (EntityCondition)conditions, null);
            for (GenericValue changeItemGV : changeItemsForFieldGVs) {
                TreeSet<ChangeItemBean> changeItemsForIssue;
                Long issueId = changeItemGV.getLong("issue");
                ChangeItemBean cib = new ChangeItemBean(changeItemGV.getString("fieldtype"), changeItemGV.getString("field"), changeItemGV.getString("oldvalue"), changeItemGV.getString("oldstring"), changeItemGV.getString("newvalue"), changeItemGV.getString("newstring"), changeItemGV.getTimestamp("created"));
                if (result.containsKey(issueId)) {
                    changeItemsForIssue = (TreeSet<ChangeItemBean>)result.get(issueId);
                } else {
                    changeItemsForIssue = new TreeSet<ChangeItemBean>(ChangeItemBeanComparator.INSTANCE);
                    result.put(issueId, changeItemsForIssue);
                }
                changeItemsForIssue.add(cib);
            }
            startIndex = ++batchNum * 500;
        }
        return result;
    }

    private List<Long> extractIssueIds(Set<StatisticHistoryDataCallback.BaseData> baseDataForIssues) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Lists.newArrayList(baseDataForIssues), (Function)new Function<StatisticHistoryDataCallback.BaseData, Long>(){

            public Long apply(StatisticHistoryDataCallback.BaseData input) {
                return input.issueId;
            }
        }));
    }

    private static class ChangeItemBeanComparator
    implements Comparator<ChangeItemBean> {
        public static final ChangeItemBeanComparator INSTANCE = new ChangeItemBeanComparator();

        private ChangeItemBeanComparator() {
        }

        @Override
        public int compare(ChangeItemBean o1, ChangeItemBean o2) {
            return o1.getCreated().compareTo(o2.getCreated());
        }
    }
}

