/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.web.rapid.chart.ChangeHistoryCollector;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import io.atlassian.fugue.Option;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.joda.time.DateTime;

public class StatisticHistoryDataCallback
implements IssueDataCallback {
    private final DocumentStatisticValueResolver documentStatisticValueResolver;
    private final String documentId;
    private final Set<BaseData> baseData = new HashSet<BaseData>();
    private BaseData tmpData;

    public StatisticHistoryDataCallback(DocumentStatisticValueResolver documentStatisticValueResolver) {
        this.documentStatisticValueResolver = documentStatisticValueResolver;
        this.documentId = documentStatisticValueResolver.getDocumentId();
        this.tmpData = new BaseData();
    }

    @Override
    public Set<String> getFields() {
        HashSet<String> fields = new HashSet<String>();
        fields.add("created");
        fields.add(this.documentId);
        return fields;
    }

    @Override
    public boolean requiresIssueDoc() {
        return false;
    }

    @Override
    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (fieldName.equals("created")) {
            this.tmpData.createdDate = ChangeHistoryCollector.epochStringToDateTime(data);
        } else {
            this.tmpData.value = this.documentStatisticValueResolver.getValue(data);
        }
    }

    @Override
    public void issueComplete(Long issueId, String issueKey, Option<Document> issueDoc) {
        this.tmpData.issueId = issueId;
        this.tmpData.issueKey = issueKey;
        this.baseData.add(this.tmpData);
        this.tmpData = new BaseData();
    }

    public Set<BaseData> getBaseData() {
        return this.baseData;
    }

    public static class BaseData {
        long issueId;
        String issueKey;
        DateTime createdDate;
        Double value;
    }
}

