/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.rapid.AuditEntry;
import com.atlassian.greenhopper.service.sprint.SprintStateAuditLog;
import com.atlassian.greenhopper.web.rapid.chart.HistoricSprintData;
import com.atlassian.jira.plugin.userformat.UserFormats;
import java.util.SortedSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintUsersData {
    @Autowired
    private UserFormats userFormats;

    public HistoricSprintData getData(SprintStateAuditLog sprintStateAuditLog) {
        SortedSet<AuditEntry> auditEntries;
        HistoricSprintData data = new HistoricSprintData();
        String closingUser = this.getUserWhoClosedIfApplicable(sprintStateAuditLog);
        if (closingUser != null) {
            data.lastUserToClose = closingUser;
        }
        if ((auditEntries = sprintStateAuditLog.getStateAuditEntries()) != null && auditEntries.size() > 0) {
            String reopeningUser;
            String openingUser = this.getUserWhoOpenedIfApplicable(auditEntries);
            if (openingUser != null) {
                data.userWhoStarted = openingUser;
            }
            if ((reopeningUser = this.getUserWhoReopenedIfApplicable(auditEntries)) != null) {
                data.userWhoLastReopened = reopeningUser;
            }
        }
        return data;
    }

    private String getUserWhoClosedIfApplicable(SprintStateAuditLog sprintStateAuditLog) {
        String closedUserKey = sprintStateAuditLog.getLastChangingUserKey();
        if (closedUserKey != null) {
            return this.userFormats.formatter("profileLink").formatUserkey(closedUserKey, "");
        }
        return null;
    }

    private String getUserWhoOpenedIfApplicable(SortedSet<AuditEntry> auditEntries) {
        AuditEntry firstEntry = auditEntries.first();
        String userWhoStarted = this.getUserWhoPerformedAction(firstEntry, "OPEN");
        if (userWhoStarted != null) {
            return userWhoStarted;
        }
        return null;
    }

    private String getUserWhoReopenedIfApplicable(SortedSet<AuditEntry> auditEntries) {
        String userWhoLastReopened;
        AuditEntry lastEntry;
        AuditEntry firstEntry;
        if (auditEntries != null && auditEntries.size() > 0 && !(firstEntry = auditEntries.first()).equals(lastEntry = auditEntries.last()) && (userWhoLastReopened = this.getUserWhoPerformedAction(lastEntry, "OPEN")) != null) {
            return userWhoLastReopened;
        }
        return null;
    }

    private String getUserWhoPerformedAction(AuditEntry auditEntry, String action) {
        String userKey;
        if (auditEntry != null && auditEntry.getData() != null && auditEntry.getData().contains(action) && (userKey = auditEntry.getUser()) != null) {
            return this.userFormats.formatter("profileLink").formatUserkey(userKey, "");
        }
        return null;
    }
}

