/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.service.sprint.Sprint;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class SprintTimes {
    private final Sprint sprint;
    private final DateTime now;
    private DateTime startTime;
    private DateTime endTime;
    private DateTime completeTime;
    private DateTime upperTimeRange;

    public SprintTimes(Sprint sprint) {
        this.sprint = sprint;
        this.now = new DateTime(DateTimeZone.UTC);
    }

    public DateTime getNow() {
        return this.now;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    @Nullable
    public DateTime getCompleteTime() {
        return this.completeTime;
    }

    @Nonnull
    public DateTime getUpperTimeRange() {
        return this.upperTimeRange;
    }

    public SprintTimes invoke() {
        this.startTime = new DateTime((Object)this.now);
        this.endTime = new DateTime((Object)this.startTime);
        this.completeTime = null;
        if (this.sprint.getStartDate() != null && this.sprint.getEndDate() != null) {
            this.startTime = this.sprint.getStartDate();
            this.endTime = this.sprint.getEndDate();
        }
        this.upperTimeRange = null;
        if (this.sprint.getCompleteDate() != null) {
            this.completeTime = this.sprint.getCompleteDate();
            this.upperTimeRange = this.completeTime.isAfter((ReadableInstant)this.endTime) ? this.completeTime : this.endTime;
        } else {
            this.upperTimeRange = this.endTime.isAfter((ReadableInstant)this.now) ? this.endTime : this.now;
        }
        return this;
    }
}

