/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.customfield.sprint.IssueKeyData;
import com.atlassian.greenhopper.customfield.sprint.SprintHistoryEntry;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.callback.ParentIssueAndSubTaskCountCallback;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintHistoryService;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.service.sprint.SprintStateAuditLog;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingHistoryService;
import com.atlassian.greenhopper.web.rapid.GHJSONMarshaller;
import com.atlassian.greenhopper.web.rapid.chart.FlotChartUtils;
import com.atlassian.greenhopper.web.rapid.chart.SprintBurndownData;
import com.atlassian.greenhopper.web.rapid.chart.SprintBurndownModel;
import com.atlassian.greenhopper.web.rapid.chart.SprintTimes;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryDataService;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryEntry;
import com.atlassian.greenhopper.web.rapid.chart.WorkRateDataFactory;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChangeUtil;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownColumnChangeData;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownColumnChangeFactory;
import com.atlassian.greenhopper.web.rapid.chart.time.WorkRateData;
import com.atlassian.greenhopper.web.rapid.view.EstimationHelper;
import com.atlassian.greenhopper.web.rapid.view.StatisticsFieldEntry;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintBurndownModelFactory {
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private TimeZoneManager timeZoneManager;
    @Autowired
    private EstimationHelper estimationHelper;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;
    @Autowired
    private TimeTrackingHistoryService timeTrackingHistoryService;
    @Autowired
    private SprintHistoryService sprintHistoryService;
    @Autowired
    private StatisticHistoryDataService statisticHistoryDataService;
    @Autowired
    private SprintService sprintService;
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private WorkRateDataFactory workRateDataFactory;
    @Autowired
    private UserFormats userFormats;
    @Autowired
    private BurndownColumnChangeFactory burndownColumnChangeFactory;
    @Autowired
    private GHJSONMarshaller ghjsonMarshaller;

    public ServiceOutcome<Map<String, List<BurndownChange>>> getBurndownChangesForSprint(ApplicationUser user, RapidView rapidView, Sprint sprint) {
        ServiceOutcome<StatisticsField> estimateStatisticStrict = this.estimateStatisticService.getEstimateStatisticStrict(rapidView);
        if (!estimateStatisticStrict.isValid()) {
            return ServiceOutcomeImpl.error(estimateStatisticStrict);
        }
        StatisticsField statisticsField = estimateStatisticStrict.getValue();
        SprintTimes sprintTimes = new SprintTimes(sprint).invoke();
        ServiceOutcome<SprintBurndownData> data = this.getScopeChangeModelDataForSprint(user, rapidView, sprint, statisticsField);
        if (!data.isValid()) {
            return ServiceOutcomeImpl.error(data);
        }
        return ServiceOutcomeImpl.ok(this.getChangesForSprint(sprintTimes.getStartTime(), sprintTimes.getCompleteTime(), data.getValue(), false));
    }

    public ServiceOutcome<SprintBurndownModel> getScopeChangeBurndownModel(ApplicationUser user, RapidView rapidView, @Nullable Long sprintId) {
        ServiceOutcome<StatisticsField> statisticsField = this.estimationHelper.getDefaultStatisticsField(rapidView);
        if (statisticsField.isInvalid()) {
            return ServiceOutcomeImpl.error(statisticsField);
        }
        return this.getScopeChangeBurndownModel(user, rapidView, sprintId, statisticsField.getValue());
    }

    public ServiceOutcome<SprintBurndownModel> getScopeChangeBurndownModel(ApplicationUser user, RapidView rapidView, @Nullable Long sprintId, String statisticFieldId) {
        ServiceOutcome<StatisticsField> statisticsField = this.estimationHelper.getStatisticsField(statisticFieldId);
        if (statisticsField.isInvalid()) {
            return ServiceOutcomeImpl.error(statisticsField);
        }
        return this.getScopeChangeBurndownModel(user, rapidView, sprintId, statisticsField.getValue());
    }

    private ServiceOutcome<SprintBurndownModel> getScopeChangeBurndownModel(ApplicationUser user, RapidView rapidView, @Nullable Long sprintId, StatisticsField statisticsField) {
        if (sprintId == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "You must specify a sprint", new Object[0]);
        }
        ServiceOutcome<Sprint> sprint = this.sprintService.getSprint(user, sprintId);
        if (sprint.isInvalid()) {
            return ServiceOutcomeImpl.error(sprint);
        }
        ServiceOutcome<SprintBurndownData> data = this.getScopeChangeModelDataForSprint(user, rapidView, sprint.get(), statisticsField);
        if (data.isInvalid()) {
            return ServiceOutcomeImpl.error(data);
        }
        return this.constructSprintBurndown(user, rapidView, sprint.get(), data.getValue());
    }

    private ServiceOutcome<SprintBurndownData> getScopeChangeModelDataForSprint(ApplicationUser user, RapidView rapidView, Sprint sprint, StatisticsField statisticsField) {
        ServiceOutcome<BurndownColumnChangeData> columnChangeData;
        boolean isTimeTracking = this.trackingStatisticService.isRemainingEstimateStatisticsField(statisticsField);
        ClauseToAdd subTaskFilteredClause = this.subTaskFilteredClause(isTimeTracking);
        ServiceOutcome<Map<String, List<SprintHistoryEntry>>> sprintHistory = this.sprintHistoryService.findSprintHistory(user, rapidView, sprint, subTaskFilteredClause);
        if (sprintHistory.isInvalid()) {
            return ServiceOutcomeImpl.error(sprintHistory);
        }
        SprintBurndownData.Builder sprintBurndownDataBuilder = SprintBurndownData.builder().setStatisticField(statisticsField);
        Map<String, List<SprintHistoryEntry>> sprintHistoryMap = BurndownChangeUtil.filterSprintHistoryEntriesBeforeSprintStart(sprint, sprintHistory.getValue());
        sprintBurndownDataBuilder.setSprintHistory(sprintHistoryMap);
        Set<String> issueKeys = sprintHistoryMap.keySet();
        if (issueKeys.isEmpty()) {
            ParentIssueAndSubTaskCountCallback parentIssueAndSubTaskCountCallback = new ParentIssueAndSubTaskCountCallback();
            this.sprintHistoryService.findSprintHistory(user, rapidView, sprint, ClauseToAdd.noClauseToAdd(), parentIssueAndSubTaskCountCallback);
            I18n2 i18n = this.i18nFactoryService.getI18n(user);
            if (parentIssueAndSubTaskCountCallback.isExclusivelySubTasks()) {
                sprintBurndownDataBuilder.setWarningMessage(i18n.getText("gh.report.sprint.only.subtasks.present"));
            } else {
                sprintBurndownDataBuilder.setWarningMessage(i18n.getText("gh.report.sprint.no.issues.present"));
            }
            return ServiceOutcomeImpl.ok(sprintBurndownDataBuilder.build());
        }
        if (!isTimeTracking) {
            ServiceOutcome<Map<String, List<StatisticHistoryEntry>>> statisticsValueHistoryOutcome = this.statisticHistoryDataService.getStatisticHistory(user, issueKeys, statisticsField, sprint.getCompleteDate());
            if (statisticsValueHistoryOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(statisticsValueHistoryOutcome);
            }
            sprintBurndownDataBuilder.setStatisticsValueHistory(statisticsValueHistoryOutcome.getValue());
        }
        if (isTimeTracking) {
            ServiceOutcome<TimeTrackingHistoryService.TimeTrackingHistory> timeTrackingHistoryOutcome = this.timeTrackingHistoryService.getTimeTrackingHistory(user, issueKeys);
            if (timeTrackingHistoryOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(timeTrackingHistoryOutcome);
            }
            sprintBurndownDataBuilder.setTimeTrackingHistory(timeTrackingHistoryOutcome.getValue().getData());
        }
        if ((columnChangeData = this.burndownColumnChangeFactory.getBurndownColumnChangeData(user, rapidView, issueKeys)).isInvalid()) {
            return ServiceOutcomeImpl.error(columnChangeData);
        }
        sprintBurndownDataBuilder.setColumns(columnChangeData.getValue().getColumns());
        sprintBurndownDataBuilder.setColumnChanges(columnChangeData.getValue().getColumnChanges());
        ServiceOutcome<IssueKeyData> issueKeyData = this.sprintHistoryService.findIssueKeysInSprint(user, rapidView, sprint, subTaskFilteredClause);
        if (issueKeyData.isInvalid()) {
            return ServiceOutcomeImpl.error(issueKeyData);
        }
        sprintBurndownDataBuilder.setIssueKeyToSummaryMap(issueKeyData.getValue().getIssueKeyToSummaryMap());
        if (isTimeTracking) {
            sprintBurndownDataBuilder.setIssueToParentKeyMap(issueKeyData.getValue().getIssueKeyToParentKeyMap());
        }
        return ServiceOutcomeImpl.ok(sprintBurndownDataBuilder.build());
    }

    private ClauseToAdd subTaskFilteredClause(boolean timeTracking) {
        ClauseToAdd subTaskFilteredClause = timeTracking ? ClauseToAdd.noClauseToAdd() : ClauseToAdd.clauseToAdd(JqlQueryBuilder.newClauseBuilder().issueTypeIsStandard().buildClause());
        return subTaskFilteredClause;
    }

    private ServiceOutcome<SprintBurndownModel> constructSprintBurndown(ApplicationUser user, RapidView rapidView, Sprint sprint, SprintBurndownData sprintBurndownData) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        TimeZone userTimeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        SprintBurndownModel model = new SprintBurndownModel();
        SprintTimes sprintTimes = new SprintTimes(sprint).invoke();
        model.statisticField = StatisticsFieldEntry.create(sprintBurndownData.getStatisticField(), i18n);
        model.startTime = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, sprintTimes.getStartTime());
        model.endTime = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, sprintTimes.getEndTime());
        model.completeTime = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, sprintTimes.getCompleteTime());
        model.now = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, sprintTimes.getNow());
        Map<String, List<BurndownChange>> changesPerIssue = this.getChangesForSprint(sprintTimes.getStartTime(), sprintTimes.getCompleteTime(), sprintBurndownData, true);
        model.issueToParentKeys = sprintBurndownData.getIssueToParentKeyMap();
        model.issueToSummary = sprintBurndownData.getIssueKeyToSummaryMap();
        model.changes = BurndownChangeUtil.transformChangesToTimeline(userTimeZone, changesPerIssue);
        ServiceOutcome<SprintStateAuditLog> sprintStateAuditLogDataServiceOutcome = this.sprintManager.getSprintStateAuditLog(sprint);
        if (sprintStateAuditLogDataServiceOutcome.isValid()) {
            SprintStateAuditLog sprintStateAuditLog = sprintStateAuditLogDataServiceOutcome.getValue();
            model.openCloseChanges = BurndownChangeUtil.transformStateChangesToTimeline(userTimeZone, this.userFormats, sprintStateAuditLog.getStateAuditEntries(), this.ghjsonMarshaller);
            if (sprint.isClosed() && sprintStateAuditLog.getLastChangingUserKey() != null) {
                model.lastUserWhoClosedHtml = BurndownChangeUtil.getProfileLinkFromUserKey(this.userFormats, sprintStateAuditLog.getLastChangingUserKey());
            }
        } else {
            return ServiceOutcomeImpl.error(sprintStateAuditLogDataServiceOutcome);
        }
        ServiceOutcome<WorkRateData> workRateData = this.workRateDataFactory.getWorkRateData(user, rapidView, sprintTimes, userTimeZone);
        if (workRateData.isInvalid()) {
            return ServiceOutcomeImpl.error(workRateData);
        }
        model.workRateData = workRateData.getValue();
        model.warningMessage = sprintBurndownData.getWarningMessage();
        return ServiceOutcomeImpl.ok(model);
    }

    private Map<String, List<BurndownChange>> getChangesForSprint(DateTime sprintStart, DateTime upperTimeRange, SprintBurndownData data, boolean trimIntraColumnMoves) {
        HashMap<String, List<BurndownChange>> changesPerIssue = new HashMap<String, List<BurndownChange>>();
        BurndownChangeUtil.addSprintHistoryChanges(sprintStart, upperTimeRange, data.getSprintHistory(), changesPerIssue);
        BurndownChangeUtil.addStatisticsValueChanges(sprintStart, upperTimeRange, data.getStatisticsValueHistory(), changesPerIssue);
        BurndownChangeUtil.addTimeTrackingChanges(sprintStart, upperTimeRange, data.getTimeTrackingHistory(), changesPerIssue);
        BurndownChangeUtil.addColumnChanges(sprintStart, upperTimeRange, data.getColumnChanges(), changesPerIssue, trimIntraColumnMoves);
        BurndownChangeUtil.optimizeBurndownChanges(changesPerIssue);
        return changesPerIssue;
    }
}

