/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.customfield.sprint.SprintHistoryEntry;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingHistoryService;
import com.atlassian.greenhopper.web.rapid.chart.IssueColumnChangeEntry;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryEntry;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

public class SprintBurndownData {
    private final List<Column> columns;
    private final Map<String, List<SprintHistoryEntry>> sprintHistory;
    private final Map<String, List<StatisticHistoryEntry>> statisticsValueHistory;
    private final StatisticsField statisticField;
    private final SortedMap<Long, Map<String, IssueColumnChangeEntry>> columnChanges;
    private final Map<String, String> issueToParentKeyMap;
    private final Map<String, String> issueKeyToSummaryMap;
    private final Map<String, List<TimeTrackingHistoryService.HistoryEntry>> timeTrackingHistory;
    private final String warningMessage;

    private SprintBurndownData(List<Column> columns, Map<String, List<SprintHistoryEntry>> sprintHistory, Map<String, List<StatisticHistoryEntry>> statisticsValueHistory, StatisticsField statisticField, SortedMap<Long, Map<String, IssueColumnChangeEntry>> columnChanges, Map<String, String> issueToParentKeyMap, Map<String, String> issueKeyToSummaryMap, Map<String, List<TimeTrackingHistoryService.HistoryEntry>> timeTrackingHistory, String warningMessage) {
        this.columns = columns;
        this.sprintHistory = sprintHistory;
        this.statisticsValueHistory = statisticsValueHistory;
        this.statisticField = statisticField;
        this.columnChanges = columnChanges;
        this.issueToParentKeyMap = issueToParentKeyMap;
        this.issueKeyToSummaryMap = issueKeyToSummaryMap;
        this.timeTrackingHistory = timeTrackingHistory;
        this.warningMessage = warningMessage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public Map<String, List<SprintHistoryEntry>> getSprintHistory() {
        return this.sprintHistory;
    }

    public Map<String, List<StatisticHistoryEntry>> getStatisticsValueHistory() {
        return this.statisticsValueHistory;
    }

    public StatisticsField getStatisticField() {
        return this.statisticField;
    }

    public SortedMap<Long, Map<String, IssueColumnChangeEntry>> getColumnChanges() {
        return this.columnChanges;
    }

    public Map<String, String> getIssueToParentKeyMap() {
        return this.issueToParentKeyMap;
    }

    public Map<String, String> getIssueKeyToSummaryMap() {
        return this.issueKeyToSummaryMap;
    }

    public Map<String, List<TimeTrackingHistoryService.HistoryEntry>> getTimeTrackingHistory() {
        return this.timeTrackingHistory;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public static class Builder {
        private List<Column> columns = Lists.newArrayList();
        private Map<String, List<SprintHistoryEntry>> sprintHistory = Maps.newHashMap();
        private Map<String, List<StatisticHistoryEntry>> statisticsValueHistory = Maps.newHashMap();
        private StatisticsField statisticField;
        private SortedMap<Long, Map<String, IssueColumnChangeEntry>> columnChanges = Maps.newTreeMap();
        private Map<String, String> issueToParentKeyMap = Maps.newHashMap();
        private Map<String, String> issueKeyToSummaryMap = Maps.newHashMap();
        private Map<String, List<TimeTrackingHistoryService.HistoryEntry>> timeTrackingHistory = Maps.newHashMap();
        private String warningMessage;

        public Builder setColumns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder setSprintHistory(Map<String, List<SprintHistoryEntry>> sprintHistory) {
            this.sprintHistory = sprintHistory;
            return this;
        }

        public Builder setStatisticsValueHistory(Map<String, List<StatisticHistoryEntry>> statisticsValueHistory) {
            this.statisticsValueHistory = statisticsValueHistory;
            return this;
        }

        public Builder setStatisticField(StatisticsField statisticField) {
            this.statisticField = statisticField;
            return this;
        }

        public Builder setColumnChanges(SortedMap<Long, Map<String, IssueColumnChangeEntry>> columnChanges) {
            this.columnChanges = columnChanges;
            return this;
        }

        public Builder setIssueToParentKeyMap(Map<String, String> issueToParentKeyMap) {
            this.issueToParentKeyMap = issueToParentKeyMap;
            return this;
        }

        public Builder setTimeTrackingHistory(Map<String, List<TimeTrackingHistoryService.HistoryEntry>> timeTrackingHistory) {
            this.timeTrackingHistory = timeTrackingHistory;
            return this;
        }

        public Builder setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        public Builder setIssueKeyToSummaryMap(Map<String, String> issueKeyToSummaryMap) {
            this.issueKeyToSummaryMap = issueKeyToSummaryMap;
            return this;
        }

        public SprintBurndownData build() {
            return new SprintBurndownData(this.columns, this.sprintHistory, this.statisticsValueHistory, this.statisticField, this.columnChanges, this.issueToParentKeyMap, this.issueKeyToSummaryMap, this.timeTrackingHistory, this.warningMessage);
        }
    }
}

