/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.web.rapid.chart.ReportContentModel;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.status.Status;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ReportModelFactory {
    @Autowired
    private ConstantsManager constantsManager;

    protected boolean isEstimable(RapidIssueEntry issueEntry) {
        return issueEntry.getEstimateStatistic() != null;
    }

    protected Double getStatFieldValue(RapidIssueEntry.StatisticFieldValue estimateStatistic) {
        if (null != estimateStatistic) {
            Double value = estimateStatistic.getStatFieldValue().getValue();
            return value == null ? 0.0 : value;
        }
        return 0.0;
    }

    protected boolean isEstimated(RapidIssueEntry issueEntry) {
        RapidIssueEntry.StatisticFieldValue statistic = issueEntry.getEstimateStatistic();
        if (statistic != null) {
            return statistic.getStatFieldValue().getValue() != null;
        }
        return false;
    }

    protected List<ReportContentModel.Status> getStatuses(List<String> statusIds) {
        ArrayList<ReportContentModel.Status> statuses = new ArrayList<ReportContentModel.Status>();
        for (String statusId : statusIds) {
            Status status = this.constantsManager.getStatusObject(statusId);
            ReportContentModel.Status statusModel = new ReportContentModel.Status();
            statusModel.name = status.getName();
            statusModel.id = statusId;
            statuses.add(statusModel);
        }
        return statuses;
    }
}

