/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.FixVersionHistoryService;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.EstimatableIssueDataCallback;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewSprintQueryService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.web.rapid.chart.FixVersionChangeEntry;
import com.atlassian.greenhopper.web.rapid.chart.ProgressChartData;
import com.atlassian.greenhopper.web.rapid.chart.ReleaseBurndownChartModel;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryDataService;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryEntry;
import com.atlassian.greenhopper.web.rapid.chart.VersionEntry;
import com.atlassian.greenhopper.web.rapid.chart.VersionEntryFactory;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChangeUtil;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownColumnChangeData;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownColumnChangeFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.rapid.view.StatisticsFieldEntry;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import io.atlassian.fugue.Option;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseBurndownChartModelFactory {
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private FixVersionHistoryService fixVersionHistoryService;
    @Autowired
    private StatisticHistoryDataService statisticHistoryDataService;
    @Autowired
    private BurndownColumnChangeFactory burndownColumnChangeFactory;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private VersionEntryFactory versionEntryFactory;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private RapidViewSprintQueryService rapidViewSprintQueryService;
    @Autowired
    private SprintEntryFactory sprintEntryFactory;
    @Autowired
    private IssueDataService issueDataService;

    public ServiceOutcome<ReleaseBurndownChartModel> getReleaseBurndownChartModel(ApplicationUser user, RapidView rapidView, Version version) {
        DateTime now = new DateTime(DateTimeZone.UTC);
        ServiceOutcome<StatisticsField> statisticsField = this.estimateStatisticService.getEstimateStatisticStrict(rapidView);
        if (!statisticsField.isValid()) {
            return ServiceOutcomeImpl.error(statisticsField);
        }
        ServiceOutcome<ProgressChartData<FixVersionChangeEntry>> versionChanges = this.getScopeChangeModelDataForVersion(user, rapidView, version, statisticsField.getValue(), now);
        if (!versionChanges.isValid()) {
            return ServiceOutcomeImpl.error(versionChanges);
        }
        return this.constructReleaseBurndownChartModel(user, rapidView, version, versionChanges.getValue(), now);
    }

    private ServiceOutcome<ProgressChartData<FixVersionChangeEntry>> getScopeChangeModelDataForVersion(ApplicationUser user, RapidView rapidView, Version version, StatisticsField statisticsField, DateTime now) {
        ServiceOutcome<Query> queryResult = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (queryResult.isInvalid()) {
            return ServiceOutcomeImpl.error(queryResult);
        }
        ServiceOutcome<Clause> statusMappingClauseOutcome = this.rapidViewQueryService.getStatusMappingClause(user, rapidView);
        if (!statusMappingClauseOutcome.isValid()) {
            return ServiceOutcomeImpl.error(statusMappingClauseOutcome);
        }
        Clause statusMappingClause = statusMappingClauseOutcome.getValue();
        Query query = JqlQueryBuilder.newBuilder((Query)queryResult.getValue()).where().defaultAnd().issueTypeIsStandard().addClause(statusMappingClause).endWhere().buildQuery();
        ServiceOutcome<Map<String, List<FixVersionChangeEntry>>> versionHistoryOutcome = this.fixVersionHistoryService.findVersionHistory(user, query, version.getId());
        if (!versionHistoryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(versionHistoryOutcome);
        }
        Set<String> issueKeys = versionHistoryOutcome.getValue().keySet();
        EstimatableIssueDataCallback estimatableIssueDataCallback = new EstimatableIssueDataCallback(this.estimateStatisticService, statisticsField, (Option<Set<String>>)Option.option(issueKeys));
        ServiceOutcome<Void> findOutcome = this.issueDataService.find(user, query, estimatableIssueDataCallback);
        if (findOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(findOutcome);
        }
        Set<String> estimatableIssues = estimatableIssueDataCallback.getEstimatableIssueKeys();
        ServiceOutcome<Map<String, List<StatisticHistoryEntry>>> statisticsValueHistoryOutcome = this.statisticHistoryDataService.getStatisticHistory(user, issueKeys, statisticsField, now);
        if (!statisticsValueHistoryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(statisticsValueHistoryOutcome);
        }
        ServiceOutcome<BurndownColumnChangeData> columnChangeData = this.burndownColumnChangeFactory.getBurndownColumnChangeData(user, rapidView, issueKeys);
        if (!columnChangeData.isValid()) {
            return ServiceOutcomeImpl.error(columnChangeData);
        }
        return ServiceOutcomeImpl.ok(new ProgressChartData(columnChangeData.getValue().getColumns(), versionHistoryOutcome.getValue(), statisticsValueHistoryOutcome.getValue(), estimatableIssues, statisticsField, columnChangeData.getValue().getColumnChanges()));
    }

    private ServiceOutcome<ReleaseBurndownChartModel> constructReleaseBurndownChartModel(ApplicationUser user, RapidView rapidView, Version version, ProgressChartData data, DateTime now) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        DateTime startDate = this.getStartDate(now, data.getHistory());
        ReleaseBurndownChartModel model = new ReleaseBurndownChartModel();
        ServiceOutcome<VersionEntry> versionEntry = this.versionEntryFactory.constructVersionEntry(version, DateTimeZone.UTC.toTimeZone(), DateTimeZone.UTC);
        if (!versionEntry.isValid()) {
            return ServiceOutcomeImpl.error(versionEntry);
        }
        model.projectKey = version.getProjectObject().getKey();
        model.version = versionEntry.getValue();
        model.startTime = startDate.getMillis();
        model.statisticField = StatisticsFieldEntry.create(data.getStatisticField(), i18n);
        model.now = now.getMillis();
        Map<String, List<BurndownChange>> changesPerIssue = this.getChangesForVersion(startDate, now, data);
        model.changes = BurndownChangeUtil.transformChangesToTimeline(DateTimeZone.UTC.toTimeZone(), changesPerIssue);
        ServiceOutcome<List<Sprint>> sprints = this.rapidViewSprintQueryService.getSprints(user, rapidView, EnumSet.of(Sprint.State.ACTIVE, Sprint.State.CLOSED), false);
        if (!sprints.isValid()) {
            return ServiceOutcomeImpl.error(sprints);
        }
        model.sprints = this.sprintEntryFactory.newReportTransformer(user).apply(sprints.getValue());
        model.estimatableIssueKeys = data.getEstimatableIssueKeys();
        return ServiceOutcomeImpl.ok(model);
    }

    private Map<String, List<BurndownChange>> getChangesForVersion(DateTime startDate, DateTime now, ProgressChartData<FixVersionChangeEntry> data) {
        HashMap<String, List<BurndownChange>> changes = new HashMap<String, List<BurndownChange>>();
        Map<String, List<FixVersionChangeEntry>> history = data.getHistory();
        BurndownChangeUtil.addVersionHistoryChanges(history, changes);
        BurndownChangeUtil.addStatisticsValueChanges(startDate, now, data.getStatisticsValueHistory(), changes);
        BurndownChangeUtil.addColumnChanges(startDate, now, data.getColumnChanges(), changes, false);
        BurndownChangeUtil.optimizeBurndownChanges(changes);
        return changes;
    }

    private DateTime getStartDate(DateTime now, Map<String, List<FixVersionChangeEntry>> history) {
        DateTime startDate = new DateTime((Object)now);
        for (List<FixVersionChangeEntry> fixVersionChangeEntries : history.values()) {
            for (FixVersionChangeEntry entry : fixVersionChangeEntries) {
                if (!entry.date.isBefore((ReadableInstant)startDate)) continue;
                startDate = entry.date;
            }
        }
        return startDate;
    }
}

