/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.chart.ControlChartModel;
import com.atlassian.greenhopper.web.rapid.chart.ControlChartModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.CumulativeFlowChartModel;
import com.atlassian.greenhopper.web.rapid.chart.CumulativeFlowChartModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.EpicBurndownChartModel;
import com.atlassian.greenhopper.web.rapid.chart.EpicBurndownChartModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.EpicProgressChartModel;
import com.atlassian.greenhopper.web.rapid.chart.EpicProgressChartModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.EpicReportModel;
import com.atlassian.greenhopper.web.rapid.chart.EpicReportModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.HistoricSprintData;
import com.atlassian.greenhopper.web.rapid.chart.HistoricSprintDataFactory;
import com.atlassian.greenhopper.web.rapid.chart.ReleaseBurndownChartModel;
import com.atlassian.greenhopper.web.rapid.chart.ReleaseBurndownChartModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.SprintBurndownModel;
import com.atlassian.greenhopper.web.rapid.chart.SprintBurndownModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.VelocityChartModel;
import com.atlassian.greenhopper.web.rapid.chart.VelocityChartModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.VersionProgressChartModel;
import com.atlassian.greenhopper.web.rapid.chart.VersionProgressChartModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.VersionReportModel;
import com.atlassian.greenhopper.web.rapid.chart.VersionReportModelFactory;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="rapid/charts")
@AnonymousAllowed
@Produces(value={"application/json"})
public class RapidChartResource
extends AbstractResource {
    private ControlChartModelFactory rapidChartFactory;
    private CumulativeFlowChartModelFactory cumulativeFlowChartModelFactory;
    private SprintBurndownModelFactory sprintBurndownModelFactory;
    private VelocityChartModelFactory velocityChartModelFactory;
    private RapidViewService rapidViewService;
    private SprintManager sprintManager;
    private HistoricSprintDataFactory historicSprintDataFactory;
    private EpicReportModelFactory epicReportModelFactory;
    private EpicProgressChartModelFactory epicProgressChartModelFactory;
    private EpicBurndownChartModelFactory epicBurndownChartModelFactory;
    private VersionProgressChartModelFactory versionProgressChartModelFactory;
    private ReleaseBurndownChartModelFactory releaseBurndownChartModelFactory;
    private IssueHelper issueHelper;
    private VersionManager versionManager;
    private VersionReportModelFactory versionReportModelFactory;

    public RapidChartResource(ControlChartModelFactory rapidChartFactory, CumulativeFlowChartModelFactory cumulativeFlowChartModelFactory, SprintBurndownModelFactory sprintBurndownModelFactory, VelocityChartModelFactory velocityChartModelFactory, RapidViewService rapidViewService, SprintManager sprintManager, HistoricSprintDataFactory historicSprintDataFactory, EpicReportModelFactory epicReportModelFactory, EpicProgressChartModelFactory epicProgressChartModelFactory, EpicBurndownChartModelFactory epicBurndownChartModelFactory, VersionProgressChartModelFactory versionProgressChartModelFactory, ReleaseBurndownChartModelFactory releaseBurndownChartModelFactory, IssueHelper issueHelper, VersionManager versionManager, VersionReportModelFactory versionReportModelFactory) {
        this.rapidChartFactory = rapidChartFactory;
        this.cumulativeFlowChartModelFactory = cumulativeFlowChartModelFactory;
        this.sprintBurndownModelFactory = sprintBurndownModelFactory;
        this.velocityChartModelFactory = velocityChartModelFactory;
        this.rapidViewService = rapidViewService;
        this.sprintManager = sprintManager;
        this.historicSprintDataFactory = historicSprintDataFactory;
        this.epicReportModelFactory = epicReportModelFactory;
        this.epicProgressChartModelFactory = epicProgressChartModelFactory;
        this.epicBurndownChartModelFactory = epicBurndownChartModelFactory;
        this.versionProgressChartModelFactory = versionProgressChartModelFactory;
        this.releaseBurndownChartModelFactory = releaseBurndownChartModelFactory;
        this.issueHelper = issueHelper;
        this.versionManager = versionManager;
        this.versionReportModelFactory = versionReportModelFactory;
    }

    @GET
    @Path(value="/controlchart")
    public Response getControlChartData(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="swimlaneId") Set<Long> swimlaneIds, final @QueryParam(value="quickFilterId") Set<Long> quickFilterIds) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome<ControlChartModel> controlChartModel = RapidChartResource.this.rapidChartFactory.buildControlChartModel(user, rapidView.getValue(), RapidChartResource.this.nullSafe(swimlaneIds), RapidChartResource.this.nullSafe(quickFilterIds));
                RapidChartResource.this.check(controlChartModel);
                return RapidChartResource.this.createOkResponse(controlChartModel.getValue());
            }
        });
    }

    @GET
    @Path(value="/cumulativeflowdiagram")
    public Response getCumulativeFlowData(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="columnId") Set<Long> columnIds, final @QueryParam(value="swimlaneId") Set<Long> swimlaneIds, final @QueryParam(value="quickFilterId") Set<Long> quickFilterIds) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome<CumulativeFlowChartModel> cfdModel = RapidChartResource.this.cumulativeFlowChartModelFactory.getCFDModel(user, rapidView.getValue(), RapidChartResource.this.nullSafe(columnIds), RapidChartResource.this.nullSafe(swimlaneIds), RapidChartResource.this.nullSafe(quickFilterIds));
                RapidChartResource.this.check(cfdModel);
                return RapidChartResource.this.createOkResponse(cfdModel.getValue());
            }
        });
    }

    @GET
    @Path(value="/scopechangeburndownchart")
    public Response getScopeChangeBurndownChart(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="sprintId") Long sprintId, final @QueryParam(value="statisticFieldId") String statisticFieldId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome<SprintBurndownModel> model = statisticFieldId == null || statisticFieldId.isEmpty() ? RapidChartResource.this.sprintBurndownModelFactory.getScopeChangeBurndownModel(user, rapidView.getValue(), sprintId) : RapidChartResource.this.sprintBurndownModelFactory.getScopeChangeBurndownModel(user, rapidView.getValue(), sprintId, statisticFieldId);
                RapidChartResource.this.check(model);
                return RapidChartResource.this.createOkResponse(model.getValue());
            }
        });
    }

    @GET
    @Path(value="/velocity")
    public Response getVelocityChart(final @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome<VelocityChartModel> model = RapidChartResource.this.velocityChartModelFactory.getVelocityChartModel(user, rapidView.getValue());
                RapidChartResource.this.check(model);
                return RapidChartResource.this.createOkResponse(model.getValue());
            }
        });
    }

    @GET
    @Path(value="/sprintreport")
    public Response getAllIssues(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="sprintId") Long sprintId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome<Sprint> sprint = RapidChartResource.this.sprintManager.getSprint(sprintId);
                RapidChartResource.this.check(sprint);
                ServiceOutcome<HistoricSprintData> data = RapidChartResource.this.historicSprintDataFactory.getSprintOriginalContents(user, rapidView.getValue(), sprint.getValue());
                RapidChartResource.this.check(data);
                return RapidChartResource.this.createOkResponse(data.getValue());
            }
        });
    }

    @GET
    @Path(value="/epicreport")
    public Response getEpicIssues(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="epicKey") String epicKey) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome<Issue> issue = RapidChartResource.this.issueHelper.findIssue(epicKey);
                RapidChartResource.this.check(issue);
                ServiceOutcome<EpicReportModel> report = RapidChartResource.this.epicReportModelFactory.getEpicReportContents(user, rapidView.getValue(), issue.getValue());
                RapidChartResource.this.check(report);
                return RapidChartResource.this.createOkResponse(report.getValue());
            }
        });
    }

    @GET
    @Path(value="/epicprogresschart")
    public Response getEpicBurnupChart(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="epicKey") String epicKey) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome<Issue> epic = RapidChartResource.this.issueHelper.findIssue(epicKey);
                RapidChartResource.this.check(epic);
                ServiceOutcome<EpicProgressChartModel> model = RapidChartResource.this.epicProgressChartModelFactory.getEpicProgressChartModel(user, rapidView.getValue(), epic.getValue());
                RapidChartResource.this.check(model);
                return RapidChartResource.this.createOkResponse(model.getValue());
            }
        });
    }

    @GET
    @Path(value="/epicburndownchart")
    public Response getEpicBurndownChart(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="epicKey") String epicKey) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome<Issue> epic = RapidChartResource.this.issueHelper.findIssue(epicKey);
                RapidChartResource.this.check(epic);
                ServiceOutcome<EpicBurndownChartModel> model = RapidChartResource.this.epicBurndownChartModelFactory.getEpicBurndownChartModel(user, rapidView.getValue(), epic.getValue());
                RapidChartResource.this.check(model);
                return RapidChartResource.this.createOkResponse(model.getValue());
            }
        });
    }

    @GET
    @Path(value="/versionprogresschart")
    public Response getVersionBurnupChart(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="versionId") Long versionId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome version = RapidChartResource.this.getVersion(versionId);
                RapidChartResource.this.check(version);
                ServiceOutcome<VersionProgressChartModel> model = RapidChartResource.this.versionProgressChartModelFactory.getVersionProgressChartModel(user, rapidView.getValue(), (Version)version.getValue());
                RapidChartResource.this.check(model);
                return RapidChartResource.this.createOkResponse(model.getValue());
            }
        });
    }

    @GET
    @Path(value="/releaseburndownchart")
    public Response getReleaseBurndownChart(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="versionId") Long versionId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome version = RapidChartResource.this.getVersion(versionId);
                RapidChartResource.this.check(version);
                ServiceOutcome<ReleaseBurndownChartModel> model = RapidChartResource.this.releaseBurndownChartModelFactory.getReleaseBurndownChartModel(user, rapidView.getValue(), (Version)version.getValue());
                RapidChartResource.this.check(model);
                return RapidChartResource.this.createOkResponse(model.getValue());
            }
        });
    }

    @GET
    @Path(value="/versionreport")
    public Response getVersionIssues(final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="versionId") Long versionId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RapidChartResource.this.getUser();
                ServiceOutcome<RapidView> rapidView = RapidChartResource.this.rapidViewService.getRapidView(user, rapidViewId);
                RapidChartResource.this.check(rapidView);
                ServiceOutcome version = RapidChartResource.this.getVersion(versionId);
                RapidChartResource.this.check(version);
                ServiceOutcome<VersionReportModel> report = RapidChartResource.this.versionReportModelFactory.getVersionReportContents(user, rapidView.getValue(), (Version)version.getValue());
                RapidChartResource.this.check(report);
                return RapidChartResource.this.createOkResponse(report.getValue());
            }
        });
    }

    private ServiceOutcome<Version> getVersion(Long versionId) {
        Version version = this.versionManager.getVersion(versionId);
        if (version == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.NOT_FOUND, "gh.rapid.charts.version.versionnotfound", new Object[0]);
        }
        if (version.isArchived()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.charts.version.versionarchived", new Object[0]);
        }
        return ServiceOutcomeImpl.ok(version);
    }
}

