/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.charts.WorkRateData;
import com.atlassian.greenhopper.model.charts.WorkRateEntry;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.service.charts.AbstractIssueHistoryStatusCallback;
import com.atlassian.jira.issue.status.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class IssueCycleTimeCollector
extends AbstractIssueHistoryStatusCallback {
    public static final long DEFAULT_LEAVE_TIME = -1L;
    private final List<Column> columns;
    private Map<Status, Column> columnsByStatus;
    private final WorkRateData rateData;
    private Map<String, SortedSet<Change>> issueColumnChanges = new HashMap<String, SortedSet<Change>>();
    private Map<String, Status> statuses;
    private Map<String, Map<Column, IssueTimes>> issueTimesData = new HashMap<String, Map<Column, IssueTimes>>();
    private DateTime now;

    public IssueCycleTimeCollector(List<Column> columns, Map<Status, Column> columnsByStatus, DateTime now, WorkRateData rateData) {
        this.columns = columns;
        this.columnsByStatus = columnsByStatus;
        this.rateData = rateData;
        this.statuses = new HashMap<String, Status>();
        for (Map.Entry<Status, Column> entry : columnsByStatus.entrySet()) {
            this.statuses.put(entry.getKey().getId(), entry.getKey());
        }
        this.now = now;
    }

    @Override
    public void changedFrom(Long issueId, String issueKey, DateTime changeTime, Status changedFromStatus) {
        this.addChange(issueKey, changeTime, true, changedFromStatus);
    }

    @Override
    public void changedTo(Long issueId, String issueKey, DateTime changeTime, Status changedToStatus) {
        this.addChange(issueKey, changeTime, false, changedToStatus);
    }

    @Override
    public void after(Status status) {
        Column column = this.columnsByStatus.get(status);
        for (Map.Entry<String, SortedSet<Change>> issueEntry : this.issueColumnChanges.entrySet()) {
            String issueKey = issueEntry.getKey();
            SortedSet<Change> changes = issueEntry.getValue();
            Durations durations = this.calculateDurations(issueKey, column, changes);
            IssueTimes columnData = this.getIssueTimes(issueKey, column);
            columnData.totalDuration += durations.totalDuration;
            columnData.workingDuration += durations.workingDuration;
            this.log.debug("%s duration for column %s: total=%s ms, working=%s ms", issueKey, this.getColumnName(column), columnData.totalDuration, columnData.workingDuration);
            columnData.leaveTime = Math.max(columnData.leaveTime, durations.lastLeaveTime);
            this.log.debug("%s last leave time for column %s: %tc", issueKey, this.getColumnName(column), columnData.leaveTime);
        }
        this.issueColumnChanges.clear();
    }

    Durations calculateDurations(String issueKey, Column column, SortedSet<Change> changes) {
        Durations durations = new Durations();
        long time = -1L;
        int currentRateIndex = 0;
        for (Change change : changes) {
            this.log.debug("%s changed %s %s at %tc", issueKey, change.leftStatus() ? "from" : "to", change.status != null ? change.status.getName() : null, change.changeTime.getMillis());
            long changeTime = change.changeTime.getMillis();
            if (!change.leftStatus()) {
                time = changeTime;
                continue;
            }
            currentRateIndex = this.addDurationsForInterval(durations, time, changeTime, currentRateIndex);
            time = changeTime;
        }
        if (!changes.isEmpty() && changes.last().enteredStatus()) {
            this.log.debug("%s is currently in column %s", issueKey, this.getColumnName(column));
            time = this.now.getMillis();
            currentRateIndex = this.addDurationsForInterval(durations, changes.last().changeTime.getMillis(), time, currentRateIndex);
        }
        durations.lastLeaveTime = time;
        return durations;
    }

    private int addDurationsForInterval(Durations data, long start, long end, int currentRateIndex) {
        long total = end - start;
        long workingDuration = 0L;
        List<WorkRateEntry> rates = this.rateData.getRates();
        int ratesCount = rates.size();
        long now = start;
        while (currentRateIndex < ratesCount) {
            WorkRateEntry rate = rates.get(currentRateIndex);
            if (rate.getEnd().getMillis() > now) {
                if (rate.getRate() > 0) {
                    long min = Math.min(end, rate.getEnd().getMillis());
                    workingDuration += min - now;
                }
                if ((now = rate.getEnd().getMillis()) >= end) break;
            }
            ++currentRateIndex;
        }
        data.totalDuration += total;
        data.workingDuration += workingDuration;
        return currentRateIndex;
    }

    @Override
    public Collection<Status> getStatuses() {
        ArrayList<Status> orderedStatuses = new ArrayList<Status>();
        for (Column column : this.columns) {
            for (String statusId : column.getStatusIds()) {
                orderedStatuses.add(this.statuses.get(statusId));
            }
        }
        return orderedStatuses;
    }

    public Set<String> getIssueKeys() {
        return this.issueTimesData.keySet();
    }

    public IssueTimesResult getIssueTimes(String issueKey) {
        IssueTimesResult result = new IssueTimesResult();
        Map<Column, IssueTimes> issueTimes = this.issueTimesData.get(issueKey);
        for (Column column : this.columns) {
            IssueTimes times = null;
            if (issueTimes != null) {
                times = issueTimes.get(column);
            }
            if (times != null) {
                result.totalDurations.add(times.totalDuration);
                result.workingDurations.add(times.workingDuration);
                result.leaveTimes.add(times.leaveTime);
                continue;
            }
            result.totalDurations.add(0L);
            result.workingDurations.add(0L);
            result.leaveTimes.add(-1L);
        }
        return result;
    }

    public DateTime getNow() {
        return this.now;
    }

    private IssueTimes getIssueTimes(String issueKey, Column column) {
        IssueTimes columnIssueData;
        Map<Column, IssueTimes> dataMap = this.issueTimesData.get(issueKey);
        if (dataMap == null) {
            dataMap = new HashMap<Column, IssueTimes>();
            this.issueTimesData.put(issueKey, dataMap);
        }
        if ((columnIssueData = dataMap.get(column)) == null) {
            columnIssueData = new IssueTimes();
            dataMap.put(column, columnIssueData);
        }
        return columnIssueData;
    }

    private void addChange(String issueKey, DateTime time, boolean leave, Status status) {
        SortedSet<Change> changes = this.issueColumnChanges.get(issueKey);
        if (changes == null) {
            changes = new TreeSet<Change>();
            this.issueColumnChanges.put(issueKey, changes);
        }
        changes.add(new Change(time, leave, status));
    }

    private String getColumnName(Column column) {
        return column != null ? column.getName() : null;
    }

    public static class IssueTimesResult {
        List<Long> workingDurations = new ArrayList<Long>();
        List<Long> totalDurations = new ArrayList<Long>();
        List<Long> leaveTimes = new ArrayList<Long>();

        public List<Long> getTotalDurations() {
            return this.totalDurations;
        }

        public List<Long> getWorkingDurations() {
            return this.workingDurations;
        }

        public List<Long> getLeaveTimes() {
            return this.leaveTimes;
        }
    }

    private static class IssueTimes {
        long totalDuration = 0L;
        long workingDuration = 0L;
        long leaveTime = -1L;

        private IssueTimes() {
        }
    }

    static class Change
    implements Comparable<Change> {
        final DateTime changeTime;
        final boolean leave;
        final Status status;

        public Change(DateTime changeTime, boolean leave, Status status) {
            this.changeTime = changeTime;
            this.leave = leave;
            this.status = status;
        }

        public boolean enteredStatus() {
            return !this.leave;
        }

        public boolean leftStatus() {
            return this.leave;
        }

        @Override
        public int compareTo(Change other) {
            int timeComparator = this.changeTime.compareTo((ReadableInstant)other.changeTime);
            if (timeComparator != 0) {
                return timeComparator;
            }
            return Boolean.valueOf(this.leave).compareTo(other.leave);
        }
    }

    static class Durations {
        long totalDuration;
        long workingDuration;
        long lastLeaveTime = -1L;

        public Durations() {
            this(0L, 0L);
        }

        public Durations(long totalDuration, long workingDuration) {
            this.totalDuration = totalDuration;
            this.workingDuration = workingDuration;
        }

        public void add(Durations d) {
            this.totalDuration += d.totalDuration;
            this.workingDuration += d.workingDuration;
        }
    }
}

