/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.service.charts.AbstractIssueHistoryStatusCallback;
import com.atlassian.greenhopper.web.rapid.chart.IssueColumnChangeEntry;
import com.atlassian.greenhopper.web.rapid.chart.SwimlaneFilter;
import com.atlassian.jira.issue.status.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.joda.time.DateTime;

public class IssueColumnChangeCollector
extends AbstractIssueHistoryStatusCallback {
    private SortedMap<Long, Map<String, IssueColumnChangeEntry>> columnChanges = new TreeMap<Long, Map<String, IssueColumnChangeEntry>>();
    private List<Column> columns;
    private Map<Status, Column> columnsByStatus;
    private Map<String, Status> statuses;
    private Map<Column, Integer> columnPositions;
    private final SwimlaneFilter swimlaneFilter;

    public IssueColumnChangeCollector(List<Column> columns, Map<Status, Column> columnsByStatus, SwimlaneFilter swimlaneFilter) {
        this.columns = columns;
        this.columnsByStatus = columnsByStatus;
        this.swimlaneFilter = swimlaneFilter;
        this.statuses = new HashMap<String, Status>();
        for (Map.Entry<Status, Column> entry : columnsByStatus.entrySet()) {
            this.statuses.put(entry.getKey().getId(), entry.getKey());
        }
        this.columnPositions = new HashMap<Column, Integer>();
        for (int i = 0; i < columns.size(); ++i) {
            this.columnPositions.put(columns.get(i), i);
        }
    }

    @Override
    public void changedFrom(Long issueId, String issueKey, DateTime changeTime, Status changedFromStatus) {
        Column from = this.columnsByStatus.get(changedFromStatus);
        this.log.debug("seen status change from %s (column %s) for %s at %tc", changedFromStatus, this.getNullSafeColumnName(from), issueKey, changeTime.getMillis());
        if (from != null) {
            this.registerColumnChange(issueKey, changeTime, from, null, null);
        }
    }

    @Override
    public void changedTo(Long issueId, String issueKey, DateTime changeTime, Status changedToStatus) {
        Column to = this.columnsByStatus.get(changedToStatus);
        this.log.debug("seen status change to %s (column %s) for %s at %tc", changedToStatus, this.getNullSafeColumnName(to), issueKey, changeTime.getMillis());
        if (to != null) {
            this.registerColumnChange(issueKey, changeTime, null, to, changedToStatus);
        }
    }

    public SortedMap<Long, Map<String, IssueColumnChangeEntry>> getColumnChanges() {
        return this.columnChanges;
    }

    @Override
    public Collection<Status> getStatuses() {
        ArrayList<Status> orderedStatuses = new ArrayList<Status>();
        for (Column column : this.columns) {
            for (String statusId : column.getStatusIds()) {
                orderedStatuses.add(this.statuses.get(statusId));
            }
        }
        return orderedStatuses;
    }

    private void registerColumnChange(String issueKey, DateTime changeTime, Column from, Column to, Status statusTo) {
        IssueColumnChangeEntry changeEntry;
        if (!this.swimlaneFilter.includes(issueKey)) {
            return;
        }
        long time = changeTime.getMillis();
        HashMap<String, IssueColumnChangeEntry> changes = (HashMap<String, IssueColumnChangeEntry>)this.columnChanges.get(time);
        if (changes == null) {
            changes = new HashMap<String, IssueColumnChangeEntry>();
            this.columnChanges.put(time, changes);
        }
        if ((changeEntry = (IssueColumnChangeEntry)changes.get(issueKey)) == null) {
            changeEntry = new IssueColumnChangeEntry();
            changeEntry.key = issueKey;
            changes.put(issueKey, changeEntry);
        }
        if (from != null) {
            this.log.debug("registering column change for %s at %tc from %s", issueKey, changeTime.getMillis(), from.getName());
            changeEntry.columnFrom = this.columnPositions.get(from);
        }
        if (to != null) {
            this.log.debug("registering column change for %s at %tc to %s", issueKey, changeTime.getMillis(), to.getName());
            changeEntry.columnTo = this.columnPositions.get(to);
        }
        if (statusTo != null) {
            changeEntry.statusTo = statusTo.getId();
        }
    }

    private String getNullSafeColumnName(Column column) {
        return column != null ? column.getName() : "[no column]";
    }
}

