/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintStateAuditLog;
import com.atlassian.greenhopper.web.rapid.chart.HistoricSprintData;
import com.atlassian.greenhopper.web.rapid.chart.HistoricSprintReportContents;
import com.atlassian.greenhopper.web.rapid.chart.SprintBurndownModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.SprintUsersData;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.chart.sprintreportfactory.HistoricSprintReportContentsFactory;
import com.atlassian.greenhopper.web.rapid.entity.sprint.SprintLinkedPagesModelFactory;
import com.atlassian.greenhopper.web.rapid.issue.StatisticFieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.statistics.HistoricalEstimateStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.StatisticValueResolverFactory;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEditEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HistoricSprintDataFactory {
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private StatisticValueResolverFactory statisticValueResolverFactory;
    @Autowired
    private IssueService issueService;
    @Autowired
    private SprintBurndownModelFactory sprintBurndownModelFactory;
    @Autowired
    private StatusManager statusManager;
    @Autowired
    private WebUtilities webUtilities;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    @Autowired
    private StatisticFieldHelper statisticFieldHelper;
    @Autowired
    private SprintEntryFactory sprintEntryFactory;
    @Autowired
    private StatusEntryFactory statusEntryFactory;
    @Autowired
    private SprintLinkedPagesModelFactory sprintLinkedPagesModelFactory;
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private SprintUsersData sprintUsersData;

    public ServiceOutcome<HistoricSprintData> getSprintOriginalContents(ApplicationUser user, RapidView rapidView, Sprint sprint) {
        ServiceOutcome<HistoricSprintReportContents> expandedSprintContents = this.getExpandedSprintContents(user, rapidView, sprint);
        if (!expandedSprintContents.isValid()) {
            return ServiceOutcomeImpl.error(expandedSprintContents);
        }
        ServiceOutcome<SprintStateAuditLog> sprintStateAuditLogDataOutcome = this.sprintManager.getSprintStateAuditLog(sprint);
        if (sprintStateAuditLogDataOutcome.isValid()) {
            HistoricSprintData data = this.sprintUsersData.getData(sprintStateAuditLogDataOutcome.getValue());
            data.sprint = (SprintEditEntry)this.sprintEntryFactory.newEditTransformer(user).apply(sprint);
            data.contents = expandedSprintContents.getValue();
            data.supportsPages = this.sprintLinkedPagesModelFactory.hasPagesSupport();
            return ServiceOutcomeImpl.ok(data);
        }
        return ServiceOutcomeImpl.error(sprintStateAuditLogDataOutcome);
    }

    private ServiceOutcome<HistoricSprintReportContents> getExpandedSprintContents(ApplicationUser user, RapidView rapidView, Sprint sprint) {
        ServiceOutcome<Map<String, List<BurndownChange>>> scopeChangeSprintReportData = this.sprintBurndownModelFactory.getBurndownChangesForSprint(user, rapidView, sprint);
        if (!scopeChangeSprintReportData.isValid()) {
            return ServiceOutcomeImpl.error(scopeChangeSprintReportData);
        }
        ServiceOutcome<CollectIssuesResult> issuesForSprint = this.getIssueKeys(user, rapidView, scopeChangeSprintReportData);
        if (!issuesForSprint.isValid()) {
            return ServiceOutcomeImpl.error(issuesForSprint);
        }
        StatisticsField estimateStatisticField = this.estimateStatisticService.getEstimateStatistic(rapidView);
        Collection<String> mappedStatusIds = this.getMappedStatusIds(rapidView);
        HistoricalEstimateStatisticValueResolver resolver = this.statisticValueResolverFactory.forHistoricalEstimateStatisticValue(estimateStatisticField, sprint, scopeChangeSprintReportData.getValue(), mappedStatusIds);
        HistoricSprintReportContentsFactory historicSprintReportContentsFactory = new HistoricSprintReportContentsFactory(issuesForSprint.getValue(), resolver, this.issueService, user, this.statisticFieldHelper, this.statusManager, this.statusEntryFactory);
        return ServiceOutcomeImpl.ok(historicSprintReportContentsFactory.create());
    }

    private Collection<String> getMappedStatusIds(RapidView rapidView) {
        Set<Status> mappedStatuses = this.columnService.getMappedStatuses(rapidView);
        return Lists.newArrayList((Iterable)Iterables.transform(mappedStatuses, (Function)new Function<Status, String>(){

            public String apply(Status from) {
                return from.getId();
            }
        }));
    }

    private ServiceOutcome<CollectIssuesResult> getIssueKeys(ApplicationUser user, RapidView rapidView, ServiceOutcome<Map<String, List<BurndownChange>>> scopeChangeSprintReportData) {
        Set<String> keys = scopeChangeSprintReportData.getValue().keySet();
        return this.rapidIssueEntryQueryService.getIssuesByKeys(user, rapidView, keys);
    }
}

