/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.rapid.MappedStatusIds;
import com.atlassian.greenhopper.service.rapid.RapidViewColumnService;
import com.atlassian.greenhopper.web.rapid.chart.EpicReportModel;
import com.atlassian.greenhopper.web.rapid.chart.ReportContentModel;
import com.atlassian.greenhopper.web.rapid.chart.ReportModelFactory;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicReportModelFactory
extends ReportModelFactory {
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    @Autowired
    private RapidViewColumnService rapidViewColumnService;

    public ServiceOutcome<EpicReportModel> getEpicReportContents(ApplicationUser user, RapidView rapidView, Issue epic) {
        ServiceOutcome<CollectIssuesResult> epicIssuesResult = this.rapidIssueEntryQueryService.collectIssuesForEpic(user, rapidView, epic.getKey());
        if (!epicIssuesResult.isValid()) {
            return ServiceOutcomeImpl.error(epicIssuesResult);
        }
        EpicReportModel reportModel = new EpicReportModel();
        reportModel.epic = this.getEpicEntry(epic);
        double completedIssuesEstimateSum = 0.0;
        double incompletedIssuesEstimateSum = 0.0;
        CollectIssuesResult issuesResult = epicIssuesResult.getValue();
        List<RapidIssueEntry> epics = issuesResult.getIssues();
        ReportContentModel reportContent = new ReportContentModel();
        ServiceOutcome<MappedStatusIds> mappedStatusIds = this.rapidViewColumnService.getMappedStatusIds(user, rapidView);
        if (!mappedStatusIds.isValid()) {
            return ServiceOutcomeImpl.error(mappedStatusIds);
        }
        List<String> doneStatusIds = mappedStatusIds.getValue().getDoneStatusIds();
        reportModel.doneStatuses = this.getStatuses(doneStatusIds);
        reportModel.notDoneStatuses = this.getStatuses(mappedStatusIds.getValue().getNotDoneStatusIds());
        for (RapidIssueEntry issueEntry : epics) {
            Double estimate = this.getStatFieldValue(issueEntry.getEstimateStatistic());
            if (doneStatusIds.contains(issueEntry.statusId)) {
                completedIssuesEstimateSum += estimate.doubleValue();
                reportContent.completedIssues.add(issueEntry);
                continue;
            }
            if (this.isEstimable(issueEntry)) {
                if (this.isEstimated(issueEntry)) {
                    incompletedIssuesEstimateSum += estimate.doubleValue();
                    reportContent.incompleteEstimatedIssues.add(issueEntry);
                    continue;
                }
                reportContent.incompleteUnestimatedIssues.add(issueEntry);
                continue;
            }
            reportContent.incompleteEstimatedIssues.add(issueEntry);
        }
        reportContent.allIssuesEstimateSum = new RapidIssueEntry.NumberFieldValue(completedIssuesEstimateSum + incompletedIssuesEstimateSum);
        reportContent.completedIssuesEstimateSum = new RapidIssueEntry.NumberFieldValue(completedIssuesEstimateSum);
        reportContent.incompletedIssuesEstimateSum = new RapidIssueEntry.NumberFieldValue(incompletedIssuesEstimateSum);
        reportContent.entityData = issuesResult.getEntityData();
        reportModel.contents = reportContent;
        return ServiceOutcomeImpl.ok(reportModel);
    }

    private EpicReportModel.EpicEntry getEpicEntry(Issue epic) {
        EpicReportModel.EpicEntry epicEntry = new EpicReportModel.EpicEntry();
        epicEntry.key = epic.getKey();
        epicEntry.id = epic.getId();
        epicEntry.summary = epic.getSummary();
        CustomField epicLabelField = this.epicCustomFieldService.getDefaultEpicLabelField();
        Object epicLabel = epic.getCustomFieldValue(epicLabelField);
        if (epicLabel != null) {
            epicEntry.label = epicLabel.toString();
        }
        return epicEntry;
    }
}

