/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkHistoryEntry;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.EpicHistoryResult;
import com.atlassian.greenhopper.service.issue.EpicHistoryService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.util.DateUtils;
import com.atlassian.greenhopper.web.rapid.chart.EpicProgressChartModel;
import com.atlassian.greenhopper.web.rapid.chart.FlotChartUtils;
import com.atlassian.greenhopper.web.rapid.chart.ProgressChartData;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryDataService;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryEntry;
import com.atlassian.greenhopper.web.rapid.chart.WorkRateDataFactory;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChangeUtil;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownColumnChangeData;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownColumnChangeFactory;
import com.atlassian.greenhopper.web.rapid.chart.time.WorkRateData;
import com.atlassian.greenhopper.web.rapid.view.StatisticsFieldEntry;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicProgressChartModelFactory {
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private TimeZoneManager timeZoneManager;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private StatisticHistoryDataService statisticHistoryDataService;
    @Autowired
    private EpicHistoryService epicHistoryService;
    @Autowired
    private WorkRateDataFactory workRateDataFactory;
    @Autowired
    private BurndownColumnChangeFactory burndownColumnChangeFactory;

    public ServiceOutcome<EpicProgressChartModel> getEpicProgressChartModel(ApplicationUser user, RapidView rapidView, Issue epic) {
        ServiceOutcome<StatisticsField> statisticsField = this.estimateStatisticService.getEstimateStatisticStrict(rapidView);
        if (!statisticsField.isValid()) {
            return ServiceOutcomeImpl.error(statisticsField);
        }
        DateTime now = new DateTime(DateTimeZone.UTC);
        ServiceOutcome<ProgressChartData> data = this.getScopeChangeModelDataForEpic(user, rapidView, epic, statisticsField.getValue(), now);
        if (!data.isValid()) {
            return ServiceOutcomeImpl.error(data);
        }
        return this.constructEpicProgressModel(user, rapidView, epic, data.getValue(), now);
    }

    private ServiceOutcome<ProgressChartData> getScopeChangeModelDataForEpic(ApplicationUser user, RapidView rapidView, Issue epic, StatisticsField statisticsField, DateTime now) {
        ServiceOutcome<EpicHistoryResult> epicHistoryOutcome = this.epicHistoryService.findEpicHistory(user, rapidView, epic, statisticsField);
        if (!epicHistoryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(epicHistoryOutcome);
        }
        Map epicHistory = epicHistoryOutcome.getValue().getIssuesEpicHistoryByIssueKey();
        Set<String> issueKeys = epicHistory.keySet();
        ServiceOutcome<Map<String, List<StatisticHistoryEntry>>> statisticsValueHistoryOutcome = this.statisticHistoryDataService.getStatisticHistory(user, issueKeys, statisticsField, now);
        if (!statisticsValueHistoryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(statisticsValueHistoryOutcome);
        }
        ServiceOutcome<BurndownColumnChangeData> columnChangeData = this.burndownColumnChangeFactory.getBurndownColumnChangeData(user, rapidView, issueKeys);
        if (!columnChangeData.isValid()) {
            return ServiceOutcomeImpl.error(columnChangeData);
        }
        return ServiceOutcomeImpl.ok(new ProgressChartData(columnChangeData.getValue().getColumns(), epicHistory, statisticsValueHistoryOutcome.getValue(), epicHistoryOutcome.getValue().getEstimatableIssueKeys(), statisticsField, columnChangeData.getValue().getColumnChanges()));
    }

    private ServiceOutcome<EpicProgressChartModel> constructEpicProgressModel(ApplicationUser user, RapidView rapidView, Issue epic, ProgressChartData data, DateTime now) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        TimeZone userTimeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        EpicProgressChartModel model = new EpicProgressChartModel();
        DateTime epicCreationDate = DateUtils.toDateTime(epic.getCreated());
        model.epicCreationTime = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, epicCreationDate);
        model.epicKey = epic.getKey();
        model.epicSummary = epic.getSummary();
        model.statisticField = StatisticsFieldEntry.create(data.getStatisticField(), i18n);
        model.now = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, now);
        Map<String, List<BurndownChange>> changesPerIssue = this.getChangesForEpic(epicCreationDate, now, data);
        model.changes = BurndownChangeUtil.transformChangesToTimeline(userTimeZone, changesPerIssue);
        ServiceOutcome<WorkRateData> workRateData = this.workRateDataFactory.getWorkRateData(user, rapidView, userTimeZone, epicCreationDate, now);
        if (!workRateData.isValid()) {
            return ServiceOutcomeImpl.error(workRateData);
        }
        model.workRateData = workRateData.getValue();
        model.estimatableIssueKeys = data.getEstimatableIssueKeys();
        return ServiceOutcomeImpl.ok(model);
    }

    private Map<String, List<BurndownChange>> getChangesForEpic(DateTime startDate, DateTime now, ProgressChartData<EpicLinkHistoryEntry> data) {
        HashMap<String, List<BurndownChange>> changes = new HashMap<String, List<BurndownChange>>();
        BurndownChangeUtil.addEpicHistoryChanges(data.getHistory(), changes);
        BurndownChangeUtil.addStatisticsValueChanges(startDate, now, data.getStatisticsValueHistory(), changes);
        BurndownChangeUtil.addColumnChanges(startDate, now, data.getColumnChanges(), changes, false);
        BurndownChangeUtil.optimizeBurndownChanges(changes);
        return changes;
    }
}

