/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.IssueStatusHistoryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneService;
import com.atlassian.greenhopper.web.rapid.chart.ChartDataHelper;
import com.atlassian.greenhopper.web.rapid.chart.CumulativeFlowChartModel;
import com.atlassian.greenhopper.web.rapid.chart.IssueColumnChangeCollector;
import com.atlassian.greenhopper.web.rapid.chart.IssueColumnChangeEntry;
import com.atlassian.greenhopper.web.rapid.chart.SwimlaneFilter;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CumulativeFlowChartModelFactory {
    @Autowired
    private IssueStatusHistoryService issueStatusHistoryService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private ChartDataHelper chartDataHelper;
    @Autowired
    private SwimlaneService swimlaneService;
    @Autowired
    private TimeZoneManager timeZoneManager;

    public ServiceOutcome<CumulativeFlowChartModel> getCFDModel(ApplicationUser user, RapidView rapidView, Set<Long> columnIds, Set<Long> swimlaneIds, Set<Long> quickFilterIds) {
        Map<Status, Column> columnsByStatus;
        List<Swimlane> allSwimlanes;
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        TimeZone userTimeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        ServiceOutcome<Query> queryOutcome = this.chartDataHelper.assembleQuery(user, rapidView, quickFilterIds);
        if (!queryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(queryOutcome);
        }
        Query query = queryOutcome.getValue();
        ServiceOutcome<SwimlaneFilter> swimlaneFilterOutcome = this.chartDataHelper.getSwimlaneFilter(user, query, allSwimlanes = this.swimlaneService.loadSwimlanes(rapidView), swimlaneIds, i18n);
        if (!swimlaneFilterOutcome.isValid()) {
            return ServiceOutcomeImpl.error(swimlaneFilterOutcome);
        }
        SwimlaneFilter swimlaneFilter = swimlaneFilterOutcome.getValue();
        List<Column> columns = this.getColumns(rapidView, columnIds);
        IssueColumnChangeCollector collector = new IssueColumnChangeCollector(columns, columnsByStatus = this.getColumnsByStatus(rapidView, columnIds), swimlaneFilter);
        ServiceOutcome<Void> outcome = this.issueStatusHistoryService.collectStatusHistory(user, query, collector);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        CumulativeFlowChartModel model = new CumulativeFlowChartModel();
        SortedMap<Long, Map<String, IssueColumnChangeEntry>> columnChanges = collector.getColumnChanges();
        for (Map.Entry<Long, Map<String, IssueColumnChangeEntry>> entry : columnChanges.entrySet()) {
            Long time = (long)userTimeZone.getOffset(entry.getKey()) + entry.getKey();
            ArrayList<IssueColumnChangeEntry> changes = (ArrayList<IssueColumnChangeEntry>)model.columnChanges.get(time);
            if (changes == null) {
                changes = new ArrayList<IssueColumnChangeEntry>();
                model.columnChanges.put(time, changes);
            }
            changes.addAll(entry.getValue().values());
        }
        for (Column column : columns) {
            CumulativeFlowChartModel.ColumnEntry columnEntry = new CumulativeFlowChartModel.ColumnEntry();
            columnEntry.name = i18n.getText(column.getName());
            model.columns.add(columnEntry);
        }
        model.firstChangeTime = columnChanges.isEmpty() ? null : columnChanges.firstKey();
        long now = new DateTime(DateTimeZone.UTC).getMillis();
        now += (long)userTimeZone.getOffset(now);
        model.now = now;
        return ServiceOutcomeImpl.ok(model);
    }

    private Map<Status, Column> getColumnsByStatus(RapidView rapidView, Set<Long> columnIds) {
        Map<Status, Column> allColumns = this.columnService.getColumnsByStatus(rapidView);
        HashMap<Status, Column> filteredColumns = new HashMap<Status, Column>();
        for (Map.Entry<Status, Column> entry : allColumns.entrySet()) {
            if (!columnIds.contains(entry.getValue().getId())) continue;
            filteredColumns.put(entry.getKey(), entry.getValue());
        }
        return filteredColumns;
    }

    private List<Column> getColumns(RapidView rapidView, Set<Long> columnIds) {
        List<Column> columns = this.columnService.getValidColumns(rapidView);
        Iterator<Column> it = columns.iterator();
        while (it.hasNext()) {
            if (columnIds.contains(it.next().getId())) continue;
            it.remove();
        }
        return columns;
    }
}

