/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.IssueStatusHistoryService;
import com.atlassian.greenhopper.service.charts.WorkRateService;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.ComposedIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneService;
import com.atlassian.greenhopper.web.rapid.chart.ChangeHistoryCollector;
import com.atlassian.greenhopper.web.rapid.chart.ChartDataHelper;
import com.atlassian.greenhopper.web.rapid.chart.ControlChartModel;
import com.atlassian.greenhopper.web.rapid.chart.IssueCycleTimeCollector;
import com.atlassian.greenhopper.web.rapid.chart.SwimlaneFilter;
import com.atlassian.greenhopper.web.rapid.chart.WorkRateDataFactory;
import com.atlassian.greenhopper.web.rapid.chart.time.WorkRateData;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ControlChartModelFactory {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private IssueStatusHistoryService issueStatusHistoryService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private SwimlaneService swimlaneService;
    @Autowired
    private ChartDataHelper chartDataHelper;
    @Autowired
    private WorkRateDataFactory workRateDataFactory;
    @Autowired
    private WorkRateService workRateService;

    public ServiceOutcome<ControlChartModel> buildControlChartModel(ApplicationUser user, RapidView rapidView, Set<Long> swimlaneIds, Set<Long> quickFilterIds) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ServiceOutcome<Query> queryOutcome = this.chartDataHelper.assembleQuery(user, rapidView, quickFilterIds);
        if (!queryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(queryOutcome);
        }
        Query query = queryOutcome.getValue();
        this.log.debug("Query including quickfilters: [%s]", query.toString());
        List<Column> validColumns = this.columnService.getValidColumns(rapidView);
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        List<Swimlane> swimlanes = this.swimlaneService.loadSwimlanes(rapidView);
        Map<Status, Column> columnsByStatus = this.columnService.getColumnsByStatus(rapidView);
        ServiceOutcome<SwimlaneFilter> swimlaneFilterOutcome = this.chartDataHelper.getSwimlaneFilter(user, rapidViewQuery.getValue(), swimlanes, swimlaneIds, i18n);
        if (!swimlaneFilterOutcome.isValid()) {
            ServiceOutcomeImpl.error(swimlaneFilterOutcome);
        }
        SwimlaneFilter swimlaneFilter = swimlaneFilterOutcome.getValue();
        return this.buildControlChartModelImpl(user, i18n, rapidView, query, validColumns, swimlaneFilter, columnsByStatus);
    }

    private ServiceOutcome<ControlChartModel> buildControlChartModelImpl(ApplicationUser user, I18n2 i18n, RapidView rapidView, Query query, List<Column> columns, SwimlaneFilter swimlaneFilter, Map<Status, Column> columnsByStatus) {
        DateTime now = new DateTime().withZone(DateTimeZone.UTC);
        SummaryIssueDataCallback summariesCallback = new SummaryIssueDataCallback();
        EarliestIssueCreationTimeCallback startDateCallback = new EarliestIssueCreationTimeCallback(now);
        ComposedIssueDataCallback composed = ComposedIssueDataCallback.of((IssueDataCallback[])new AbstractIssueDataCallback[]{summariesCallback, startDateCallback});
        this.issueDataService.find(user, query, composed);
        ServiceOutcome<com.atlassian.greenhopper.model.charts.WorkRateData> rateData = this.workRateService.getRateData(user, rapidView, startDateCallback.getEarliestCreationDate(), now);
        if (!rateData.isValid()) {
            return ServiceOutcomeImpl.error(rateData);
        }
        IssueCycleTimeCollector collector = new IssueCycleTimeCollector(columns, columnsByStatus, now, rateData.getValue());
        ServiceOutcome<Void> outcome = this.issueStatusHistoryService.collectStatusHistory(user, query, collector);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        ControlChartModel chartModel = new ControlChartModel();
        ArrayList<ControlChartModel.ControlChartEntry> entries = new ArrayList<ControlChartModel.ControlChartEntry>();
        for (String string : collector.getIssueKeys()) {
            if (!swimlaneFilter.includes(string)) continue;
            IssueCycleTimeCollector.IssueTimesResult issueTimes = collector.getIssueTimes(string);
            ControlChartModel.ControlChartEntry chartEntry = new ControlChartModel.ControlChartEntry();
            chartEntry.key = string;
            chartEntry.totalTime = issueTimes.getTotalDurations();
            chartEntry.workingTime = issueTimes.getWorkingDurations();
            chartEntry.leaveTimes = issueTimes.getLeaveTimes();
            chartEntry.summary = summariesCallback.getSummary(string);
            chartEntry.swimlaneId = swimlaneFilter.getSwimlaneId(string);
            entries.add(chartEntry);
        }
        chartModel.issues = entries;
        chartModel.currentTime = collector.getNow().getMillis();
        ArrayList<ControlChartModel.ColumnInfo> columnsInfo = new ArrayList<ControlChartModel.ColumnInfo>();
        for (Column column : columns) {
            ControlChartModel.ColumnInfo info = new ControlChartModel.ColumnInfo();
            info.name = i18n.getText(column.getName());
            info.id = column.getId();
            columnsInfo.add(info);
        }
        chartModel.columns = columnsInfo;
        ServiceOutcome<WorkRateData> serviceOutcome = this.workRateDataFactory.toWorkRateData(DateTimeZone.UTC.toTimeZone(), rateData.getValue());
        if (!serviceOutcome.isValid()) {
            return ServiceOutcomeImpl.error(serviceOutcome);
        }
        chartModel.workRateData = serviceOutcome.getValue();
        return ServiceOutcomeImpl.ok(chartModel);
    }

    private static class EarliestIssueCreationTimeCallback
    extends AbstractIssueDataCallback {
        private DateTime earliestCreationDate;
        private static final Set<String> FIELDS = new HashSet<String>(Arrays.asList("created"));

        public EarliestIssueCreationTimeCallback(DateTime now) {
            this.earliestCreationDate = now;
        }

        @Override
        public Set<String> getFields() {
            return FIELDS;
        }

        @Override
        public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
            DateTime createdDate = ChangeHistoryCollector.epochStringToDateTime(data);
            if (createdDate.isBefore((ReadableInstant)this.earliestCreationDate)) {
                this.earliestCreationDate = createdDate;
            }
        }

        public DateTime getEarliestCreationDate() {
            return this.earliestCreationDate;
        }
    }

    private static class SummaryIssueDataCallback
    extends AbstractIssueDataCallback {
        private static final Set<String> FIELDS = new HashSet<String>(Arrays.asList("summary"));
        private Map<String, String> summaries = new HashMap<String, String>();

        private SummaryIssueDataCallback() {
        }

        @Override
        public Set<String> getFields() {
            return FIELDS;
        }

        @Override
        public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
            this.summaries.put(issueKey, data);
        }

        public String getSummary(String issueKey) {
            return this.summaries.get(issueKey);
        }
    }
}

