/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.query.ClauseToAdd;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.AbstractIssueDataCallback;
import com.atlassian.greenhopper.service.issue.callback.IssueDataCallback;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.web.rapid.chart.SwimlaneFilter;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChartDataHelper {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private JqlQueryParser jqlQueryParser;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private IssueDataService issueDataService;
    @Autowired
    private ColumnService columnService;

    @Nonnull
    public ServiceOutcome<SwimlaneFilter> getSwimlaneFilter(ApplicationUser user, Query query, List<Swimlane> allSwimlanes, Set<Long> swimlaneIds, I18n2 i18n) {
        boolean allLanes = true;
        for (Swimlane swimlane : allSwimlanes) {
            if (swimlaneIds.contains(swimlane.getId())) continue;
            allLanes = false;
            break;
        }
        if (allLanes) {
            this.log.debug("Swimlane filter for allLanes", new Object[0]);
            return ServiceOutcomeImpl.ok(SwimlaneFilter.allSwimlanes());
        }
        LinkedHashMap<Long, ArrayList<String>> swimlaneIssues = new LinkedHashMap<Long, ArrayList<String>>();
        HashSet<String> allIssues = new HashSet<String>();
        for (Swimlane swimlane : allSwimlanes) {
            ArrayList<String> issuesInThisSwimlane = new ArrayList<String>();
            IssueKeyVisitingDataCallback callback = new IssueKeyVisitingDataCallback(allIssues, issuesInThisSwimlane);
            if (!swimlane.isDefaultLane()) {
                try {
                    this.runQueryForSwimlaneAndCollect(user, query, swimlane, callback);
                }
                catch (IllegalArgumentException e) {
                    this.log.exception(e);
                    return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.swimlane.invalid.configuration", i18n.getText(swimlane.getName()));
                }
                catch (JqlParseException e) {
                    this.log.exception(e);
                    return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.swimlane.invalid.configuration", i18n.getText(swimlane.getName()));
                }
            } else {
                this.runQueryAndCollect(user, query, callback);
            }
            swimlaneIssues.put(swimlane.getId(), issuesInThisSwimlane);
        }
        HashMap<String, Long> issuesIncludedBySwimlanes = new HashMap<String, Long>();
        for (Long swimlaneId : swimlaneIds) {
            List issuesInThisSwimlane = (List)swimlaneIssues.get(swimlaneId);
            if (issuesInThisSwimlane != null) {
                for (String issueKey : issuesInThisSwimlane) {
                    issuesIncludedBySwimlanes.put(issueKey, swimlaneId);
                }
                continue;
            }
            this.log.warn("Ignoring invalid swimlane id '%d'", swimlaneId);
        }
        this.log.debug("Swimlane filter: allLanes=%s, included issues=%s", allLanes, issuesIncludedBySwimlanes);
        return ServiceOutcomeImpl.ok(new SwimlaneFilter(issuesIncludedBySwimlanes));
    }

    @Nonnull
    public ServiceOutcome<Query> assembleQuery(ApplicationUser user, RapidView rapidView, Set<Long> quickfilterIds) {
        ServiceOutcome<ClauseToAdd> quickFilterClause;
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        JqlQueryBuilder query = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue());
        Set<Status> mappedStatuses = this.columnService.getMappedStatuses(rapidView);
        if (!mappedStatuses.isEmpty()) {
            ImmutableList statusIds = ImmutableList.copyOf((Iterable)Iterables.transform(mappedStatuses, (Function)new Function<Status, String>(){

                public String apply(Status status) {
                    return status.getId();
                }
            }));
            query.where().and().status().in().strings((Collection)statusIds);
        }
        if (!(quickFilterClause = this.rapidViewQueryService.getQuickFilterClause(user, rapidView, quickfilterIds)).isValid()) {
            return ServiceOutcomeImpl.error(quickFilterClause);
        }
        quickFilterClause.getValue().appendWithDefaultAnd(query);
        return ServiceOutcomeImpl.ok(query.buildQuery());
    }

    private void runQueryForSwimlaneAndCollect(ApplicationUser user, Query query, Swimlane swimlane, IssueDataCallback callback) throws JqlParseException {
        Clause swimlaneClause = this.jqlQueryParser.parseQuery(swimlane.getQuery()).getWhereClause();
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)query);
        if (swimlaneClause != null) {
            builder.where().and().addClause(swimlaneClause);
        }
        Query swimlaneQuery = builder.buildQuery();
        this.log.debug("including swimlane %s : [%s]", swimlane.getName(), swimlaneQuery);
        this.runQueryAndCollect(user, swimlaneQuery, callback);
    }

    private void runQueryAndCollect(ApplicationUser user, Query query, IssueDataCallback callback) {
        this.log.debug("running query [%s]", query);
        this.issueDataService.find(user, query, callback);
    }

    private static class IssueKeyVisitingDataCallback
    extends AbstractIssueDataCallback {
        private final Set<String> visitedIssues;
        private final List<String> swimlaneIssues;

        public IssueKeyVisitingDataCallback(Set<String> visitedIssues, List<String> swimlaneIssues) {
            this.visitedIssues = visitedIssues;
            this.swimlaneIssues = swimlaneIssues;
        }

        @Override
        public Set<String> getFields() {
            HashSet<String> fields = new HashSet<String>();
            fields.add("key");
            return fields;
        }

        @Override
        public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
            if (!this.visitedIssues.contains(issueKey)) {
                this.visitedIssues.add(issueKey);
                this.swimlaneIssues.add(issueKey);
            }
        }
    }
}

