/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.service.charts.ChangeHistoryCallback;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.greenhopper.util.lucene.LimitedStoredFieldVisitor;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.BitSet;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.joda.time.DateTime;

public class ChangeHistoryCollector<T>
extends SimpleCollector {
    private final IndexSearcher searcher;
    private final ChangeHistoryCallback callback;
    private final BitSet filter;
    private Boolean changedFrom;
    private T changeValue;
    private final ImmutableSet<String> fieldsToLoad;
    private int docBase;

    public ChangeHistoryCollector(IndexSearcher searcher, ChangeHistoryCallback callback, BitSet filter, Boolean changedFrom, T changeValue, Set<String> fieldsToLoad) {
        this.searcher = searcher;
        this.callback = callback;
        this.filter = filter;
        this.changedFrom = changedFrom;
        this.changeValue = changeValue;
        this.fieldsToLoad = ImmutableSet.copyOf(fieldsToLoad);
    }

    public void collect(int doc) throws IOException {
        int index = this.docBase + doc;
        if (this.filter.get(index)) {
            LimitedStoredFieldVisitor fieldVisitor = new LimitedStoredFieldVisitor((Set<String>)this.fieldsToLoad);
            this.searcher.doc(index, (StoredFieldVisitor)fieldVisitor);
            Document d = fieldVisitor.getDocument();
            Long issueId = NumberUtils.toLong(d.get("issue_id"));
            String issueKey = d.get("key");
            DateTime changeDate = ChangeHistoryCollector.epochStringToDateTime(d.get("ch_date"));
            if (this.changedFrom.booleanValue()) {
                this.callback.changedFrom(issueId, issueKey, changeDate, this.changeValue);
            } else {
                this.callback.changedTo(issueId, issueKey, changeDate, this.changeValue);
            }
        }
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docBase = context.docBase;
    }

    public boolean needsScores() {
        return false;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public static DateTime epochStringToDateTime(String epochString) {
        Validate.notNull((Object)epochString, (String)"date string must not be null", (Object[])new Object[0]);
        long timeSinceEpoch = Long.parseLong(epochString);
        Date date = timeSinceEpoch == Long.MAX_VALUE ? null : new Date(timeSinceEpoch);
        return new DateTime((Object)date);
    }
}

