/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.greenhopper.web.contextprovider.IssuesInEpicContext;
import com.atlassian.greenhopper.web.contextprovider.IssuesInEpicContextProvider;
import com.atlassian.jira.bc.issue.IssueService;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewIssuesInEpicAction
extends GreenHopperWebActionSupport {
    @Autowired
    private IssuesInEpicContextProvider ctxProvider;
    @Autowired
    private IssueService issueService;
    private Map<String, Object> context;
    private String epicKey;
    private IssuesInEpicContext issuesInEpic;

    public String getEpicKey() {
        return this.epicKey;
    }

    public void setEpicKey(String epicKey) {
        this.epicKey = epicKey;
    }

    public String doGet() {
        this.tagRequestAsJIRASoftwareForMAU();
        this.context = Maps.newHashMap();
        if (this.epicKey == null) {
            return "error";
        }
        IssueService.IssueResult issue = this.issueService.getIssue(this.getLoggedInApplicationUser(), this.epicKey);
        if (!issue.isValid()) {
            return "error";
        }
        this.context.put("issue", issue.getIssue());
        this.context.put("user", this.getLoggedInApplicationUser());
        return "success";
    }

    public Collection<String> getErrorMessages() {
        return Collections.emptyList();
    }

    public Map<String, String> getErrors() {
        return Maps.newHashMap();
    }

    public IssuesInEpicContext getIssuesInEpicContext() {
        if (this.issuesInEpic == null) {
            this.issuesInEpic = (IssuesInEpicContext)this.ctxProvider.getContextMap(this.context).get("issuesInEpicContext");
        }
        return this.issuesInEpic;
    }
}

