/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.service.properties.UserPropertyService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.QuickEditSettingsModel;
import com.atlassian.greenhopper.web.rapid.UserConfigurationService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="userData")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserDataResource
extends AbstractResource {
    private UserPropertyService userPropertyService;
    private UserConfigurationService userConfigurationService;

    public UserDataResource(UserPropertyService userPropertyService, UserConfigurationService userConfigurationService) {
        this.userPropertyService = userPropertyService;
        this.userConfigurationService = userConfigurationService;
    }

    @PUT
    @Path(value="/quickEditDefaults")
    public Response putQuickEditDefaults(final QuickEditSettingsModel settings) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() {
                ApplicationUser user = UserDataResource.this.getUser();
                if (settings.issueTypeId != null) {
                    UserDataResource.this.userPropertyService.setQuickCreateIssueTypeId(UserDataResource.this.authenticationContext.getLoggedInUser(), String.valueOf(settings.issueTypeId));
                }
                UserDataResource.this.userPropertyService.setQuickCreateFields(user, settings.fields);
                UserDataResource.this.userPropertyService.setUseQuickFormPreference(user, settings.useQuickForm);
                return UserDataResource.this.createOkResponse(UserDataResource.this.loadQuickEditSettings());
            }
        });
    }

    @GET
    @Path(value="/quickEditDefaults")
    public Response getQuickEditDefaults() {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() {
                return UserDataResource.this.createOkResponse(UserDataResource.this.loadQuickEditSettings());
            }
        });
    }

    private QuickEditSettingsModel loadQuickEditSettings() {
        ApplicationUser user = this.getUser();
        QuickEditSettingsModel model = new QuickEditSettingsModel();
        model.issueTypeId = this.userPropertyService.getQuickCreateIssueTypeId(this.authenticationContext.getLoggedInUser());
        model.fields = this.userPropertyService.getQuickCreateFields(user);
        model.useQuickForm = this.userPropertyService.getUseQuickFormPreference(user);
        return model;
    }

    @GET
    @Path(value="/userConfig")
    public Response getUserConfig() {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() {
                return UserDataResource.this.createOkResponse(UserDataResource.this.userConfigurationService.getUserConfig(UserDataResource.this.getUser()));
            }
        });
    }
}

