/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.rapid.SavedFilterService;
import com.atlassian.greenhopper.service.user.GHAvatarService;
import com.atlassian.greenhopper.web.rapid.UserConfig;
import com.atlassian.greenhopper.web.rapid.view.KanbanPlanModeResource;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserConfigurationService {
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ProjectService jiraProjectService;
    @Autowired
    private SavedFilterService savedFilterService;
    @Autowired
    private GHAvatarService avatarService;
    @Autowired
    private UserPreferencesManager userPreferencesManager;
    private static final String IS_CLOSED_KANPLAN_ACKNOWLEDGE_WORKMODE = "kanplan.acknowledge.work.mode.close";
    private static final String IS_CLOSED_KANPLAN_ACKNOWLEDGE_PLANMODE = "kanplan.acknowledge.plan.mode.close";
    private static final String IS_CLOSED_KANPLAN_EPICS_ONBOADING_WORKMODE = "kanplan.epics.onboarding.work.mode.close";
    private static final String IS_CLOSED_KANPLAN_EPICS_ONBOADING_PLANMODE = "kanplan.epics.onboarding.plan.mode.close";
    private static final String IS_CLOSED_SPRINT_GOAL_ONBOADING = "sprint.goal.onboarding.close";

    public UserConfig getUserConfig(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user);
        UserConfig userConfig = new UserConfig();
        userConfig.canCreateBoard = this.permissionService.hasGlobalPermission(user, 22);
        userConfig.canCreateIssue = this.permissionService.canCreateIssue(user);
        userConfig.canCreateProject = this.permissionService.canCreateProject(user);
        userConfig.isGlobalAdmin = this.permissionService.isJiraAdministrator(user);
        ServiceOutcome allProjectsOutcome = this.jiraProjectService.getAllProjects(user);
        userConfig.hasProjectsAccessible = allProjectsOutcome.isValid() ? !((List)allProjectsOutcome.getReturnedValue()).isEmpty() : false;
        userConfig.hasFiltersAccessible = this.savedFilterService.canUserSeeAnySavedFilters(user);
        userConfig.name = user.getName();
        userConfig.displayName = user.getDisplayName();
        userConfig.avatarUrl = this.avatarService.getSmallAvatarURL(user);
        return userConfig;
    }

    public KanbanPlanModeResource.KanPlanOnboardingStateModel getKanPlanAcknowledgeDisplay(@Nullable ApplicationUser user) {
        KanbanPlanModeResource.KanPlanOnboardingStateModel result = new KanbanPlanModeResource.KanPlanOnboardingStateModel();
        if (Objects.nonNull(user)) {
            ExtendedPreferences userExtendedPreferences = this.userPreferencesManager.getExtendedPreferences(user);
            result.isClosedOnPlanMode = userExtendedPreferences.getBoolean(IS_CLOSED_KANPLAN_ACKNOWLEDGE_PLANMODE);
            result.isClosedOnWorkMode = userExtendedPreferences.getBoolean(IS_CLOSED_KANPLAN_ACKNOWLEDGE_WORKMODE);
        } else {
            result.isClosedOnPlanMode = true;
            result.isClosedOnWorkMode = true;
        }
        return result;
    }

    public ServiceResult setClosedKanPlanAcknowledge(@Nonnull String modeName, @Nonnull ApplicationUser user) {
        Objects.requireNonNull(modeName);
        Objects.requireNonNull(user);
        try {
            if (modeName.equals("plan")) {
                this.userPreferencesManager.getExtendedPreferences(user).setBoolean(IS_CLOSED_KANPLAN_ACKNOWLEDGE_PLANMODE, true);
            } else {
                this.userPreferencesManager.getExtendedPreferences(user).setBoolean(IS_CLOSED_KANPLAN_ACKNOWLEDGE_WORKMODE, true);
            }
            return ServiceResultImpl.ok();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public KanbanPlanModeResource.KanPlanOnboardingStateModel getKanPlanEpicsOnboardingState(@Nullable ApplicationUser user) {
        KanbanPlanModeResource.KanPlanOnboardingStateModel result = new KanbanPlanModeResource.KanPlanOnboardingStateModel();
        if (Objects.nonNull(user)) {
            ExtendedPreferences userExtendedPreferences = this.userPreferencesManager.getExtendedPreferences(user);
            result.isClosedOnWorkMode = userExtendedPreferences.getBoolean(IS_CLOSED_KANPLAN_EPICS_ONBOADING_WORKMODE);
            result.isClosedOnPlanMode = userExtendedPreferences.getBoolean(IS_CLOSED_KANPLAN_EPICS_ONBOADING_PLANMODE);
        } else {
            result.isClosedOnPlanMode = true;
            result.isClosedOnWorkMode = true;
        }
        return result;
    }

    public ServiceResult setEpicsOnboardingDialogAsClosed(@Nonnull String modeName, @Nonnull ApplicationUser user) {
        Objects.requireNonNull(modeName);
        Objects.requireNonNull(user);
        try {
            if (modeName.equals("work")) {
                this.userPreferencesManager.getExtendedPreferences(user).setBoolean(IS_CLOSED_KANPLAN_EPICS_ONBOADING_WORKMODE, true);
            } else if (modeName.equals("plan")) {
                this.userPreferencesManager.getExtendedPreferences(user).setBoolean(IS_CLOSED_KANPLAN_EPICS_ONBOADING_PLANMODE, true);
            } else if (modeName.equals("both")) {
                this.userPreferencesManager.getExtendedPreferences(user).setBoolean(IS_CLOSED_KANPLAN_EPICS_ONBOADING_WORKMODE, true);
                this.userPreferencesManager.getExtendedPreferences(user).setBoolean(IS_CLOSED_KANPLAN_EPICS_ONBOADING_PLANMODE, true);
            }
            return ServiceResultImpl.ok();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean getSprintGoalOnboardingState(@Nullable ApplicationUser user) {
        if (Objects.nonNull(user)) {
            ExtendedPreferences userExtendedPreferences = this.userPreferencesManager.getExtendedPreferences(user);
            return userExtendedPreferences.getBoolean(IS_CLOSED_SPRINT_GOAL_ONBOADING);
        }
        return false;
    }

    public ServiceResult setSprintGoalOnboardingDialogAsClosed(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user);
        try {
            this.userPreferencesManager.getExtendedPreferences(user).setBoolean(IS_CLOSED_SPRINT_GOAL_ONBOADING, true);
            return ServiceResultImpl.ok();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ServiceResult setSprintGoalOnboardingDialogAsOpen(@Nonnull ApplicationUser user) {
        Objects.requireNonNull(user);
        try {
            this.userPreferencesManager.getExtendedPreferences(user).setBoolean(IS_CLOSED_SPRINT_GOAL_ONBOADING, false);
            return ServiceResultImpl.ok();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

