/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.analytics.FailedKanbanTransitionAnalyticsEvent;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.AbstractIssueTransitionStrategy;
import com.atlassian.greenhopper.web.rapid.IssueTransitionAndRankService;
import com.atlassian.greenhopper.web.rapid.issue.IssueTransitions;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.google.common.base.Preconditions;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SingleIssueTransitionStrategy
extends AbstractIssueTransitionStrategy {
    @Autowired
    protected IssueService issueService;
    @Autowired
    private EventPublisher eventPublisher;

    @Override
    public ServiceOutcome<IssueTransitionAndRankService.TransitionAndRankResult> transitionIssues(List<Issue> issues, Column targetColumn, Integer selectedTransitionId) {
        IssueService.TransitionValidationResult transitionValidationResult;
        Preconditions.checkArgument((issues.size() == 1 ? 1 : 0) != 0, (Object)"Number of issues doesn't equal to 1");
        Issue issue = issues.get(0);
        Integer transitionId = selectedTransitionId;
        if (transitionId == null) {
            ServiceOutcome<IssueTransitions> transitionsOutcome = this.findApplicableTransitions(issue, targetColumn);
            if (transitionsOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(transitionsOutcome);
            }
            IssueTransitions issueTransitions = transitionsOutcome.get();
            if (issueTransitions.transitions.isEmpty()) {
                String targetColumnName = this.jiraAuthenticationContext.getI18nHelper().getText(targetColumn.getName());
                this.eventPublisher.publish((Object)new FailedKanbanTransitionAnalyticsEvent(this.isColumnSelectedForDevelopment(targetColumn), issues.size(), "no-available-transitions"));
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.plan.kanban.transition.single.issue.no.transition.available", targetColumnName);
            }
            if (issueTransitions.transitions.size() == 1 && !issueTransitions.transitions.get((int)0).hasTransitionView) {
                transitionId = issueTransitions.transitions.get((int)0).id;
            } else {
                return ServiceOutcomeImpl.ok(IssueTransitionAndRankService.TransitionAndRankResult.withPossibleTransitions(issueTransitions.transitions));
            }
        }
        if (!(transitionValidationResult = this.issueService.validateTransition(this.jiraAuthenticationContext.getLoggedInUser(), issue.getId(), transitionId.intValue(), (IssueInputParameters)new IssueInputParametersImpl())).isValid()) {
            return ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(transitionValidationResult.getErrorCollection());
        }
        IssueService.IssueResult issueResult = this.issueService.transition(this.jiraAuthenticationContext.getLoggedInUser(), transitionValidationResult);
        if (!issueResult.isValid()) {
            return ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(issueResult.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(IssueTransitionAndRankService.TransitionAndRankResult.issuesWereTransitioned());
    }
}

