/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.rapid.BoardLocation;
import com.atlassian.greenhopper.service.rapid.RapidViewLocationService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.web.rapid.RapidViewLocationResolver;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UrlBuilder;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidViewLocationResolverFactory {
    @Autowired
    private IssueRapidViewLocationResolver issueBoardLocationResolver;
    @Autowired
    private SprintRapidViewLocationResolver sprintBoardLocationResolver;

    public RapidViewLocationResolver<Issue> forIssue() {
        return this.issueBoardLocationResolver;
    }

    public RapidViewLocationResolver<Sprint> forSprint() {
        return this.sprintBoardLocationResolver;
    }

    @Service
    static class SprintRapidViewLocationResolver
    extends AbstractRapidViewLocationResolver<Sprint> {
        @Autowired
        private SprintService sprintService;
        @Autowired
        private RapidViewLocationService rapidViewLocationService;

        SprintRapidViewLocationResolver() {
        }

        @Override
        public ServiceOutcome<Sprint> getObject(ApplicationUser user, Long id) {
            return this.sprintService.getSprint(user, id);
        }

        @Override
        public ServiceOutcome<Set<RapidView>> getRapidViewsForObject(ApplicationUser user, Sprint sprint) {
            return this.rapidViewLocationService.getRapidViewsForSprint(user, sprint.getId());
        }

        @Override
        protected ServiceOutcome<BoardLocation> getBoardLocation(ApplicationUser user, Sprint sprint, RapidView rapidView) {
            return this.rapidViewLocationService.getBoardLocationForSprint(user, sprint);
        }
    }

    @Service
    static class IssueRapidViewLocationResolver
    extends AbstractRapidViewLocationResolver<Issue> {
        @Autowired
        private IssueHelper issueHelper;
        @Autowired
        private RapidViewLocationService rapidViewLocationService;
        @Autowired
        private IssueTypeService issueTypeService;

        IssueRapidViewLocationResolver() {
        }

        @Override
        public ServiceOutcome<Issue> getObject(ApplicationUser user, Long id) {
            return this.issueHelper.findIssue(String.valueOf(id));
        }

        @Override
        public ServiceOutcome<Set<RapidView>> getRapidViewsForObject(ApplicationUser user, Issue issue) {
            return this.rapidViewLocationService.getRapidViewsForIssue(user, issue);
        }

        @Override
        protected ServiceOutcome<BoardLocation> getBoardLocation(ApplicationUser user, Issue issue, RapidView rapidView) {
            return this.rapidViewLocationService.getBoardLocationForIssue(user, issue, rapidView);
        }

        @Override
        protected UrlBuilder addExtraParameters(UrlBuilder urlBuilder, Issue issue, BoardLocation boardLocation) {
            String issueIdParamName = "selectedIssue";
            String selectedIssueKey = issue.getKey();
            if (BoardLocation.Modes.PLAN == boardLocation.getMode() && issue.isSubTask()) {
                selectedIssueKey = issue.getParentObject().getKey();
            } else if (BoardLocation.Modes.PLAN == boardLocation.getMode() && this.issueTypeService.getOrCreateEpicIssueType().equals(issue.getIssueTypeObject())) {
                issueIdParamName = "selectedEpic";
            }
            return urlBuilder.addParameter(issueIdParamName, selectedIssueKey).addParameter("projectKey", issue.getProjectObject().getKey());
        }
    }

    static abstract class AbstractRapidViewLocationResolver<T>
    implements RapidViewLocationResolver<T> {
        @Autowired
        private RapidViewService rapidViewService;

        AbstractRapidViewLocationResolver() {
        }

        @Override
        public ServiceOutcome<String> getUrl(ApplicationUser user, T object, Long rapidViewId) {
            ServiceOutcome<RapidView> rapidView = this.rapidViewService.getRapidView(user, rapidViewId);
            if (!rapidView.isValid()) {
                return ServiceOutcomeImpl.error(rapidView);
            }
            ServiceOutcome<BoardLocation> boardLocation = this.getBoardLocation(user, object, rapidView.getValue());
            if (!boardLocation.isValid()) {
                return ServiceOutcomeImpl.error(boardLocation);
            }
            UrlBuilder urlBuilder = this.buildUrlForLocation(rapidViewId, boardLocation.getValue());
            urlBuilder = this.addExtraParameters(urlBuilder, object, boardLocation.getValue());
            return ServiceOutcomeImpl.ok(urlBuilder.asUrlString());
        }

        private UrlBuilder buildUrlForLocation(Long rapidViewId, BoardLocation boardLocation) {
            UrlBuilder urlBuilder = new UrlBuilder("/secure/RapidBoard.jspa").addParameter("rapidView", (Object)rapidViewId);
            switch (boardLocation.getMode()) {
                case WORK: {
                    break;
                }
                case PLAN: {
                    urlBuilder.addParameter("view", "planning");
                    break;
                }
                case REPORT: {
                    urlBuilder.addParameter("view", "reporting").addParameter("chart", "sprintRetrospective").addParameter("sprint", (Object)boardLocation.getSprintId());
                }
            }
            return urlBuilder;
        }

        protected abstract ServiceOutcome<BoardLocation> getBoardLocation(ApplicationUser var1, T var2, RapidView var3);

        protected UrlBuilder addExtraParameters(UrlBuilder urlBuilder, T object, BoardLocation boardLocation) {
            return urlBuilder;
        }
    }
}

