/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.features.AgileDarkFeature;
import com.atlassian.greenhopper.features.JiraSoftwareFeature;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.QuickFilter;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.RapidViewNameComparator;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldInstance;
import com.atlassian.greenhopper.model.rapid.Swimlane;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceOutcomes;
import com.atlassian.greenhopper.service.configuration.JiraSoftwareFeatureService;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.properties.UserPropertyService;
import com.atlassian.greenhopper.service.rapid.RapidViewHistoryService;
import com.atlassian.greenhopper.service.rapid.view.BoardAdminService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.QuickFilterService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewPermissionService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.StatisticsFieldService;
import com.atlassian.greenhopper.service.rapid.view.SwimlaneService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.greenhopper.web.rapid.RapidConfig;
import com.atlassian.greenhopper.web.rapid.RapidGlobalConfig;
import com.atlassian.greenhopper.web.rapid.RapidViewConfig;
import com.atlassian.greenhopper.web.rapid.RapidViewEntry;
import com.atlassian.greenhopper.web.rapid.RapidViewsModel;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.UserConfigurationService;
import com.atlassian.greenhopper.web.rapid.chart.VersionEntryFactory;
import com.atlassian.greenhopper.web.rapid.view.StatisticsFieldEntry;
import com.atlassian.greenhopper.web.util.DatePickerHelper;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RapidBoardViewModelFactory {
    @Autowired
    private RapidViewPermissionService rapidViewPermissionService;
    @Autowired
    private SprintPermissionService sprintPermissionService;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private QuickFilterService quickFilterService;
    @Autowired
    private SwimlaneService swimlaneService;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private StatisticsFieldService statisticsFieldService;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;
    @Autowired
    private UserPropertyService userPropertyService;
    @Autowired
    private DatePickerHelper datePickerHelper;
    @Autowired
    private JiraAuthenticationContext authContext;
    @Autowired
    private TimeTrackingConfiguration timeTrackingConfiguration;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private RapidViewHistoryService rapidViewHistoryService;
    @Autowired
    private JiraSoftwareFeatureService jiraSoftwareFeaturesService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private SprintCustomFieldService sprintCustomFieldService;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private TimeZoneManager timeZoneManager;
    @Autowired
    private UserConfigurationService userConfigurationService;
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private BoardAdminService boardAdminService;

    private List<RapidViewEntry> asViewEntries(ApplicationUser user, List<RapidView> views) {
        ArrayList<RapidViewEntry> entries = new ArrayList<RapidViewEntry>();
        for (RapidView view : views) {
            entries.add(this.asViewEntry(user, view));
        }
        return new ArrayList<RapidViewEntry>(entries);
    }

    private RapidViewEntry asViewEntry(ApplicationUser user, RapidView view) {
        return RapidViewEntry.fromRapidView(view, this.rapidViewPermissionService.canEdit(user, view), this.columnService.isKanPlanEnabledForBoard(view));
    }

    public RapidViewsModel getRapidViewsModel(ApplicationUser user) {
        List views = (List)MoreObjects.firstNonNull(this.getRapidViewsSortedByName(user).getValue(), Collections.emptyList());
        RapidView lastViewed = this.rapidViewHistoryService.getMostRecent(user);
        RapidViewsModel model = new RapidViewsModel();
        model.rapidViews = this.asViewEntries(user, views);
        if (lastViewed != null) {
            model.lastViewed = this.asViewEntry(user, lastViewed);
        }
        return model;
    }

    private ServiceOutcome<List<RapidView>> getRapidViewsSortedByName(ApplicationUser user) {
        ServiceOutcome<List<RapidView>> rapidViews = this.rapidViewService.getRapidViews(user);
        return ServiceOutcomes.map(rapidViews, new Function<List<RapidView>, List<RapidView>>(){

            public List<RapidView> apply(List<RapidView> views) {
                Collections.sort(views, RapidViewNameComparator.INSTANCE);
                return views;
            }
        });
    }

    public ServiceOutcome<RapidConfig> getRapidViewConfigModel(ApplicationUser user, RapidView rapidView) {
        RapidConfig config = new RapidConfig();
        config.currentViewConfig = this.buildRapidViewConfig(user, rapidView);
        config.globalConfig = this.buildRapidGlobalConfig(user);
        return ServiceOutcomeImpl.ok(config);
    }

    public RapidGlobalConfig buildRapidGlobalConfig(ApplicationUser user) {
        RapidGlobalConfig config = new RapidGlobalConfig();
        config.parallelSprints = this.jiraSoftwareFeaturesService.isFeatureEnabled(JiraSoftwareFeature.PARALLEL_SPRINTS);
        config.daysInColumn = this.jiraSoftwareFeaturesService.isFeatureEnabled(JiraSoftwareFeature.DAYS_IN_COLUMN);
        config.kanPlanLabEnabled = this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN);
        config.epicConfig = this.getEpicConfig();
        config.sprintConfig = this.getSprintConfig();
        config.dateFormat = this.datePickerHelper.getCalendarFormat();
        config.dateTimePickerFormat = CustomFieldUtils.getDateTimeFormat();
        TimeZone loggedInUserTimeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        config.userTimeZoneLabel = VersionEntryFactory.formatTimeZoneOffset(DateTimeZone.forTimeZone((TimeZone)loggedInUserTimeZone), DateTime.now());
        config.numberGroupingSeparator = this.getGroupingSeparator();
        config.numberDecimalSeparator = this.getDecimalSeparator();
        config.timeTrackingConfig = this.getTimeTrackingConfig();
        config.quickCreateDefaultIssueTypeId = this.userPropertyService.getQuickCreateIssueTypeId(user);
        config.userConfig = this.userConfigurationService.getUserConfig(user);
        config.isSampleDataAvailable = this.isSampleDataAvailable();
        return config;
    }

    private boolean isSampleDataAvailable() {
        return !this.featureManager.isEnabled((Feature)AgileDarkFeature.DISABLE_CREATE_PROJECT);
    }

    private RapidViewConfig buildRapidViewConfig(ApplicationUser user, RapidView rapidView) {
        RestTemplate entry;
        RapidViewConfig config = new RapidViewConfig();
        if (rapidView == null) {
            config.noRapidViews = true;
            return config;
        }
        boolean canEdit = this.rapidViewPermissionService.canEdit(user, rapidView);
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        config.id = rapidView.getId();
        config.name = rapidView.getName();
        config.canEdit = canEdit;
        config.canManageSprints = this.sprintPermissionService.hasManageSprintsPermission(user, rapidView);
        config.sprintSupportEnabled = rapidView.isSprintSupportEnabled();
        config.swimlaneStrategy = rapidView.getSwimlaneStrategy().getId();
        config.showDaysInColumn = rapidView.showDaysInColumn();
        config.kanPlanEnabled = this.columnService.isKanPlanEnabledForBoard(rapidView);
        config.isBoardAdmin = this.boardAdminService.isUserBoardAdmin(rapidView, user);
        config.showEpicAsPanel = rapidView.getShowEpicsAsPanel().isEnabled();
        config.oldDoneIssuesCutoff = rapidView.getOldDoneIssuesCutoff().getValue();
        config.fastKanbanEnabled = this.featureManager.isEnabled(SoftwareFeatureFlags.KANBAN_HIDE_OLD_DONE_ISSUES);
        config.quickFilters = new ArrayList<RapidViewConfig.QuickFilterEntry>();
        for (QuickFilter quickFilter : this.quickFilterService.loadQuickFilters(rapidView)) {
            entry = new RapidViewConfig.QuickFilterEntry();
            entry.id = quickFilter.getId();
            entry.name = i18n.getText(quickFilter.getName());
            entry.description = i18n.getText(quickFilter.getDescription());
            entry.query = quickFilter.getQuery();
            config.quickFilters.add((RapidViewConfig.QuickFilterEntry)entry);
        }
        config.swimlanes = new ArrayList<RapidViewConfig.SwimlaneEntry>();
        for (Swimlane swimlane : this.swimlaneService.loadSwimlanes(rapidView)) {
            entry = new RapidViewConfig.SwimlaneEntry();
            ((RapidViewConfig.SwimlaneEntry)entry).id = swimlane.getId();
            ((RapidViewConfig.SwimlaneEntry)entry).name = i18n.getText(swimlane.getName());
            ((RapidViewConfig.SwimlaneEntry)entry).description = i18n.getText(swimlane.getDescription());
            ((RapidViewConfig.SwimlaneEntry)entry).query = swimlane.getQuery();
            ((RapidViewConfig.SwimlaneEntry)entry).isDefault = swimlane.isDefaultLane();
            config.swimlanes.add((RapidViewConfig.SwimlaneEntry)entry);
        }
        config.columns = new ArrayList<RapidViewConfig.MappedColumn>();
        for (Column column : this.columnService.getValidColumns(rapidView)) {
            entry = new RapidViewConfig.MappedColumn();
            ((RapidViewConfig.MappedColumn)entry).id = column.getId();
            ((RapidViewConfig.MappedColumn)entry).name = i18n.getText(column.getName());
            ((RapidViewConfig.MappedColumn)entry).statusIds = column.getStatusIds();
            ((RapidViewConfig.MappedColumn)entry).isKanPlanColumn = KanbanBacklogColumn.isKanbanBacklogColumn(column);
            config.columns.add((RapidViewConfig.MappedColumn)entry);
        }
        ServiceOutcome<RapidViewConfig.StatisticsConfig> statisticsConfig = this.getStatisticsConfig(rapidView, i18n);
        if (statisticsConfig.isValid()) {
            config.statisticConfig = statisticsConfig.getValue();
        }
        config.estimationStatistic = StatisticsFieldEntry.create(this.estimateStatisticService.getEstimateStatistic(rapidView), i18n);
        config.trackingStatistic = StatisticsFieldEntry.create(this.trackingStatisticService.getTrackingStatistic(rapidView), i18n);
        return config;
    }

    private RapidGlobalConfig.TimeTrackingConfig getTimeTrackingConfig() {
        RapidGlobalConfig.TimeTrackingConfig timeTrackingConfig = new RapidGlobalConfig.TimeTrackingConfig();
        timeTrackingConfig.daysPerWeek = this.getDaysPerWeek();
        timeTrackingConfig.hoursPerDay = this.getHoursPerDay();
        timeTrackingConfig.symbols = this.getTimeTrackingSymbols();
        timeTrackingConfig.timeFormat = this.getTimeFormat();
        return timeTrackingConfig;
    }

    private RapidGlobalConfig.TimeTrackingSymbolsConfig getTimeTrackingSymbols() {
        RapidGlobalConfig.TimeTrackingSymbolsConfig timeTrackingSymbolsConfig = new RapidGlobalConfig.TimeTrackingSymbolsConfig();
        timeTrackingSymbolsConfig.minute = "m";
        timeTrackingSymbolsConfig.hour = "h";
        timeTrackingSymbolsConfig.day = "d";
        timeTrackingSymbolsConfig.week = "w";
        return timeTrackingSymbolsConfig;
    }

    private RapidGlobalConfig.SprintConfig getSprintConfig() {
        RapidGlobalConfig.SprintConfig sprintConfig = new RapidGlobalConfig.SprintConfig();
        sprintConfig.sprintFieldId = this.sprintCustomFieldService.getDefaultSprintField().getId();
        return sprintConfig;
    }

    private RapidGlobalConfig.EpicConfig getEpicConfig() {
        RapidGlobalConfig.EpicConfig data = new RapidGlobalConfig.EpicConfig();
        IssueType storyPointIssueType = this.issueTypeService.getOrCreateStoryIssueType();
        data.storyIssueTypeId = storyPointIssueType.getId();
        data.storyIssueTypeName = storyPointIssueType.getName();
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        data.epicIssueTypeId = epicIssueType.getId();
        data.epicIssueTypeName = epicIssueType.getName();
        data.epicLabelFieldId = this.epicCustomFieldService.getDefaultEpicLabelField().getId();
        CustomField defaultEpicStatusField = this.epicCustomFieldService.getDefaultEpicStatusField();
        data.epicStatusFieldId = defaultEpicStatusField.getId();
        io.atlassian.fugue.Option<Option> doneEpicStatusOption = this.epicCustomFieldService.getDoneEpicStatusOption();
        if (!doneEpicStatusOption.isEmpty()) {
            data.epicStatusDoneValueId = ((Option)doneEpicStatusOption.get()).getOptionId();
        }
        data.epicColorFieldId = this.epicCustomFieldService.getDefaultEpicColorField().getId();
        data.epicLinkFieldId = this.epicCustomFieldService.getDefaultEpicLinkField().getId();
        data.epicLinkFieldName = this.epicCustomFieldService.getDefaultEpicLinkField().getName();
        return data;
    }

    public ServiceOutcome<RapidViewConfig.StatisticsConfig> getStatisticsConfig(RapidView rapidView, I18n2 i18n) {
        ServiceOutcome<StatisticsFieldInstance> instanceResult = this.statisticsFieldService.loadStatisticsFieldInstance(rapidView);
        if (!instanceResult.isValid()) {
            return ServiceOutcomeImpl.error(instanceResult);
        }
        StatisticsFieldInstance instance = instanceResult.getValue();
        StatisticsFieldConfig fieldConfig = instance.getConfig();
        RapidViewConfig.StatisticsConfig config = new RapidViewConfig.StatisticsConfig();
        config.fieldConfigured = !StatisticsFieldConfig.Type.NONE.equals((Object)fieldConfig.getType());
        config.typeId = fieldConfig.getType().getId();
        config.id = fieldConfig.getFieldId();
        config.name = instance.getName(i18n);
        return ServiceOutcomeImpl.ok(config);
    }

    public String getGroupingSeparator() {
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        if (symbols != null) {
            return new String(new char[]{symbols.getGroupingSeparator()});
        }
        return "";
    }

    public String getDecimalSeparator() {
        DecimalFormatSymbols symbols = this.getDecimalFormatSymbols();
        if (symbols != null) {
            return new String(new char[]{symbols.getDecimalSeparator()});
        }
        return "";
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        NumberFormat numberFormat = NumberFormat.getInstance(this.getLocale());
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            return decimalFormat.getDecimalFormatSymbols();
        }
        return null;
    }

    private Locale getLocale() {
        return this.authContext.getLocale();
    }

    public BigDecimal getHoursPerDay() {
        return this.timeTrackingConfiguration.getHoursPerDay();
    }

    public BigDecimal getDaysPerWeek() {
        return this.timeTrackingConfiguration.getDaysPerWeek();
    }

    public String getTimeFormat() {
        return this.applicationProperties.getString("jira.timetracking.format");
    }
}

