/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.rest.ArrayBean;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.project.ProjectHistoryService;
import com.atlassian.greenhopper.service.rapid.RapidViewHistoryService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.IssueTransitionAndRankService;
import com.atlassian.greenhopper.web.rapid.RapidBoardViewModelFactory;
import com.atlassian.greenhopper.web.rapid.RapidConfig;
import com.atlassian.greenhopper.web.rapid.RapidViewsModel;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.config.tab.BoardConfigTab;
import com.atlassian.greenhopper.web.rapid.config.tab.BoardConfigTabsResolver;
import com.atlassian.greenhopper.web.rapid.issue.TransitionEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.tools.BoardToolSectionContext;
import com.atlassian.greenhopper.web.rapid.tools.BoardToolSectionsResolver;
import com.atlassian.greenhopper.web.rapid.tools.RapidBoardToolSections;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="xboard")
@AnonymousAllowed
@Produces(value={"application/json"})
public class RapidBoardResource
extends AbstractResource {
    private final RapidBoardViewModelFactory rapidViewFactory;
    private final RapidViewService rapidViewService;
    private final RapidViewHistoryService rapidViewHistoryService;
    private final ProjectHistoryService projectHistoryService;
    private final BoardToolSectionsResolver boardToolSectionsResolver;
    private final BoardConfigTabsResolver boardConfigTabsResolver;
    private final IssueTransitionAndRankService issueTransitionAndRankService;

    public RapidBoardResource(RapidBoardViewModelFactory rapidViewFactory, RapidViewService rapidViewService, RapidViewHistoryService rapidViewHistoryService, ProjectHistoryService projectHistoryService, BoardToolSectionsResolver boardToolSectionsResolver, BoardConfigTabsResolver boardConfigTabsResolver, IssueTransitionAndRankService issueTransitionAndRankService) {
        this.rapidViewFactory = rapidViewFactory;
        this.rapidViewService = rapidViewService;
        this.rapidViewHistoryService = rapidViewHistoryService;
        this.projectHistoryService = projectHistoryService;
        this.boardToolSectionsResolver = boardToolSectionsResolver;
        this.boardConfigTabsResolver = boardConfigTabsResolver;
        this.issueTransitionAndRankService = issueTransitionAndRankService;
    }

    @GET
    @Path(value="/toolSections")
    public Response getToolSections(@QueryParam(value="mode") String modeStr, @QueryParam(value="rapidViewId") long rapidViewId, @QueryParam(value="selectedProjectKey") String selectedProjectKey, @Context HttpServletRequest request) {
        ServiceOutcome<RapidView> outcome;
        BoardToolSectionContext.Mode mode = BoardToolSectionContext.Mode.fromName(modeStr);
        if (!this.isGadgetRequest() && BoardToolSectionContext.Mode.REPORT == mode && (outcome = this.rapidViewService.getRapidView(this.getUser(), rapidViewId)).isValid()) {
            RapidView rapidView = outcome.getValue();
            this.projectHistoryService.registerRecentProjects(this.getUser(), rapidView, Collections.emptyList(), selectedProjectKey);
        }
        return this.responseWithoutAccessCheck(() -> {
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(this.getUser(), rapidViewId));
            BoardToolSectionContext context = new BoardToolSectionContext(rapidView, mode, request);
            return this.createOkResponse(new RapidBoardToolSections(this.boardToolSectionsResolver.getSections(context)));
        });
    }

    @GET
    @Path(value="/selectorData")
    public Response getSelectorData() {
        return this.response(() -> {
            RapidViewsModel model = this.rapidViewFactory.getRapidViewsModel(this.getUser());
            return this.createOkResponse(model);
        });
    }

    @GET
    @Path(value="/config")
    public Response getConfig(@QueryParam(value="rapidViewId") Long rapidViewId, @QueryParam(value="returnDefaultBoard") Boolean returnDefaultBoard) {
        return this.response(() -> {
            ServiceOutcome<RapidView> outcome;
            RapidView actualView = rapidViewId == null ? this.getSensibleDefaultView() : (!(outcome = this.rapidViewService.getRapidView(this.getUser(), rapidViewId)).isValid() && Boolean.TRUE.equals(returnDefaultBoard) ? this.getSensibleDefaultView() : this.check(outcome));
            ServiceOutcome<RapidConfig> result = this.rapidViewFactory.getRapidViewConfigModel(this.getUser(), actualView);
            if (!this.isGadgetRequest()) {
                this.rapidViewHistoryService.storeRapidView(this.getUser(), actualView);
            }
            return this.createOkResponse(result.getValue());
        });
    }

    @PUT
    @Path(value="/transitionAndRank")
    public Response transitionAndRank(TransitionAndRankRequest request) {
        IssueTransitionAndRankService.TransitionAndRankResult result = this.check(this.issueTransitionAndRankService.transitionAndRankIssue(this.getUser(), request.asServiceRequest()));
        return this.response(() -> this.createOkResponse(TransitionAndRankResponse.fromServiceResult(result)));
    }

    @GET
    @Path(value="/configuration-tabs")
    public Response getConfigurationTabs(@QueryParam(value="rapidViewId") long rapidViewId, @Context HttpServletRequest request) {
        return this.response(() -> {
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(this.getUser(), rapidViewId));
            List<BoardConfigTab> pages = this.boardConfigTabsResolver.getTabs(rapidView, request);
            return this.createOkResponse(new ArrayBean<BoardConfigTab>(pages));
        });
    }

    private RapidView getSensibleDefaultView() {
        RapidView actualView = this.rapidViewHistoryService.getMostRecent(this.getUser());
        if (actualView == null) {
            ServiceOutcome<RapidView> firstVisible = this.rapidViewService.getFirstVisibleRapidView(this.getUser());
            actualView = firstVisible.getValue();
        }
        return actualView;
    }

    @XmlRootElement
    public static class TransitionAndRankResponse
    extends RestTemplate {
        @XmlElement
        public boolean issuesWereTransitioned;
        @XmlElement
        public List<TransitionEntry> possibleTransitions;
        @XmlElement
        public List<String> newIssuesOrder;
        @XmlElement
        public final Set<RapidIssueEntry> updatedIssues;
        @XmlElement
        public final long transitionTime;
        @XmlElement
        public final long rankingTime;

        private TransitionAndRankResponse(boolean issuesWereTransitioned, List<TransitionEntry> possibleTransitions, List<String> newIssuesOrder, Set<RapidIssueEntry> updatedIssues, long transitionTime, long rankingTime) {
            this.issuesWereTransitioned = issuesWereTransitioned;
            this.possibleTransitions = possibleTransitions;
            this.newIssuesOrder = newIssuesOrder;
            this.updatedIssues = updatedIssues;
            this.transitionTime = transitionTime;
            this.rankingTime = rankingTime;
        }

        public static TransitionAndRankResponse fromServiceResult(IssueTransitionAndRankService.TransitionAndRankResult result) {
            return new TransitionAndRankResponse(result.isIssuesWereTransitioned(), result.getPossibleTransitions(), result.getNewIssuesOrder(), result.getUpdatedIssues(), result.getTransitionTime(), result.getRankingTime());
        }
    }

    @XmlRootElement
    public static class TransitionAndRankRequest
    extends RestTemplate {
        @XmlElement
        public Long rapidViewId;
        @XmlElement
        public List<String> issueKeys;
        @XmlElement
        public Long targetColumn;
        @XmlElement
        public Integer selectedTransitionId;
        @XmlElement
        public Long rankCustomFieldId;
        @XmlElement
        public String rankBeforeIssueIdOrKey;
        @XmlElement
        public String rankAfterIssueIdOrKey;
        @XmlElement
        public boolean calculateNewIssuesOrder;
        @XmlElement
        public Set<Long> activeQuickFilters;

        public IssueTransitionAndRankService.TransitionAndRankRequest asServiceRequest() {
            return new IssueTransitionAndRankService.TransitionAndRankRequest(this.rapidViewId, this.issueKeys, this.targetColumn, this.selectedTransitionId, this.rankCustomFieldId, this.rankBeforeIssueIdOrKey, this.rankAfterIssueIdOrKey, this.calculateNewIssuesOrder, this.activeQuickFilters);
        }
    }
}

