/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.features.JiraSoftwareFeature;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.greenhopper.manager.rapidview.RapidViewManager;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.configuration.JiraSoftwareFeatureService;
import com.atlassian.greenhopper.service.index.IndexCheckService;
import com.atlassian.greenhopper.service.properties.UserPropertyService;
import com.atlassian.greenhopper.service.query.QueryService;
import com.atlassian.greenhopper.service.rapid.RapidViewHistoryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.upgrade.UpgradeVersionService;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.greenhopper.web.rapid.GHJSONMarshaller;
import com.atlassian.greenhopper.web.rapid.Mode;
import com.atlassian.greenhopper.web.rapid.data.RapidViewConfigDataProvider;
import com.atlassian.greenhopper.web.rapid.event.UnlicensedAnalyticsEvent;
import com.atlassian.greenhopper.web.rapid.response.RapidBoardActionRedirect;
import com.atlassian.greenhopper.web.rapid.response.RapidBoardActionResult;
import com.atlassian.greenhopper.web.rapid.response.RapidBoardActionView;
import com.atlassian.greenhopper.web.rapid.view.RapidViewListHelper;
import com.atlassian.greenhopper.web.rapid.view.RapidViewListModel;
import com.atlassian.greenhopper.web.sidebar.BoardSidebarRenderer;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.onboarding.OnboardingService;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.projects.unlicensed.UnlicensedProjectPageRenderer;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RapidBoardAction
extends GreenHopperWebActionSupport {
    protected final LoggerWrapper log = LoggerWrapper.with(((Object)((Object)this)).getClass());
    private static final ProjectTypeKey SOFTWARE_PROJECT_KEY = new ProjectTypeKey("software");
    private static final String CHART_PARAMETER = "chart";
    private static final String AGILE_NAMESPACE = "com.atlassian.greenhopper";
    private static final String DETAILSVIEW_CONTEXT = "gh-rapid-detailsview";
    private static final int RECENT_BOARDS_DISPLAYED = 9;
    private final BoardSidebarRenderer boardSidebarRenderer;
    private final IndexCheckService indexCheckService;
    private final LicenseService licenseService;
    private final PermissionManager permissionManager;
    private final RapidViewHistoryService rapidViewHistoryService;
    private final RapidViewConfigDataProvider rapidViewConfigDataProvider;
    private final TaskManager taskManager;
    private final UpgradeVersionService upgradeVersionService;
    private final UserPropertyService userPropertyService;
    private final QueryService queryService;
    private final RapidViewListHelper rapidViewListHelper;
    private final GHJSONMarshaller jsonMarshaller;
    private final OnboardingService onboardingService;
    private final RapidViewManager rapidViewManager;
    private final ErrorCollectionTransformer errorCollectionTransformer;
    private final UnlicensedProjectPageRenderer unlicensedProjectPageRenderer;
    private final PageBuilderService pageBuilderService;
    private final EventPublisher eventPublisher;
    private final ColumnService columnService;
    private final VelocityRequestContextFactory contextFactory;
    private final FeatureManager featureManager;
    private final IssueService issueService;
    private JiraSoftwareFeatureService jiraSoftwareFeaturesService;
    private final RapidViewService rapidViewService;
    private String projectKey;
    private String rapidView;
    private RapidView rapidViewModel;
    private Map<IndexCheckService.CheckType, ServiceOutcome<Void>> checkResults;
    private final Supplier<RapidViewListModel> recentBoards = Suppliers.memoize((Supplier)new Supplier<RapidViewListModel>(){

        public RapidViewListModel get() {
            ServiceOutcome<RapidViewListModel> recentBoards = RapidBoardAction.this.rapidViewListHelper.getRecentBoards(RapidBoardAction.this.getLoggedInUser(), 9);
            if (recentBoards.isValid()) {
                return recentBoards.getValue();
            }
            RapidBoardAction.this.log.info("failed to load recent boards: %s", RapidBoardAction.this.errorCollectionTransformer.toJiraErrorCollection(recentBoards.getErrors()));
            return null;
        }
    });

    @Autowired
    public RapidBoardAction(BoardSidebarRenderer boardSidebarRenderer, IndexCheckService indexCheckService, LicenseService licenseService, PermissionManager permissionManager, RapidViewHistoryService rapidViewHistoryService, RapidViewConfigDataProvider rapidViewConfigDataProvider, TaskManager taskManager, UpgradeVersionService upgradeVersionService, UserPropertyService userPropertyService, QueryService queryService, RapidViewListHelper rapidViewListHelper, GHJSONMarshaller jsonMarshaller, OnboardingService onboardingService, RapidViewManager rapidViewManager, ErrorCollectionTransformer errorCollectionTransformer, UnlicensedProjectPageRenderer unlicensedProjectPageRenderer, PageBuilderService pageBuilderService, EventPublisher eventPublisher, ColumnService columnService, VelocityRequestContextFactory contextFactory, FeatureManager featureManager, IssueService issueService, JiraSoftwareFeatureService jiraSoftwareFeatureService, RapidViewService rapidViewService) {
        this.boardSidebarRenderer = boardSidebarRenderer;
        this.indexCheckService = indexCheckService;
        this.licenseService = licenseService;
        this.permissionManager = permissionManager;
        this.rapidViewHistoryService = rapidViewHistoryService;
        this.rapidViewConfigDataProvider = rapidViewConfigDataProvider;
        this.taskManager = taskManager;
        this.upgradeVersionService = upgradeVersionService;
        this.userPropertyService = userPropertyService;
        this.queryService = queryService;
        this.rapidViewListHelper = rapidViewListHelper;
        this.jsonMarshaller = jsonMarshaller;
        this.onboardingService = onboardingService;
        this.rapidViewManager = rapidViewManager;
        this.errorCollectionTransformer = errorCollectionTransformer;
        this.unlicensedProjectPageRenderer = unlicensedProjectPageRenderer;
        this.pageBuilderService = pageBuilderService;
        this.eventPublisher = eventPublisher;
        this.columnService = columnService;
        this.contextFactory = contextFactory;
        this.featureManager = featureManager;
        this.issueService = issueService;
        this.jiraSoftwareFeaturesService = jiraSoftwareFeatureService;
        this.rapidViewService = rapidViewService;
    }

    public String doShowBoard() {
        this.tagRequestAsJIRASoftwareForMAU();
        if (!this.canBrowseProjects()) {
            return this.redirectUnauthorizedUser().apply(this);
        }
        RapidBoardActionResult licenseCheckResult = this.performLicenseChecks(UnlicensedAnalyticsEvent.Page.RAPID_BOARD);
        if (!RapidBoardActionView.SUCCESS.equals(licenseCheckResult)) {
            return licenseCheckResult.apply(this);
        }
        RapidBoardActionResult preConditionsOutcome = this.checkPreConditions();
        if (!RapidBoardActionView.SUCCESS.equals(preConditionsOutcome)) {
            return preConditionsOutcome.apply(this);
        }
        RapidBoardActionResult result = this.loadModelForViewId();
        if (result == RapidBoardActionView.SUCCESS) {
            this.rapidViewHistoryService.storeRapidView(this.getLoggedInUser(), this.rapidViewModel);
            this.appendConfigurationDataToPage();
        }
        return result.apply(this);
    }

    public String doShowManageBoards() {
        this.tagRequestAsJIRASoftwareForMAU();
        this.pageBuilderService.assembler().resources().requireContext("gh-rapid-manage");
        RapidBoardActionResult licenseCheckResult = this.performLicenseChecks(UnlicensedAnalyticsEvent.Page.MANAGE_RAPID_VIEWS);
        if (!RapidBoardActionView.SUCCESS.equals(licenseCheckResult)) {
            return licenseCheckResult.apply(this);
        }
        RapidBoardActionResult preConditionsOutcome = this.checkPreConditions();
        return preConditionsOutcome.apply(this);
    }

    public String doShow() {
        this.tagRequestAsJIRASoftwareForMAU();
        if (!this.canBrowseProjects()) {
            return this.redirectUnauthorizedUser().apply(this);
        }
        RapidBoardActionResult licenseCheckResult = this.performLicenseChecks(UnlicensedAnalyticsEvent.Page.RAPID_VIEW);
        if (!RapidBoardActionView.SUCCESS.equals(licenseCheckResult)) {
            return licenseCheckResult.apply(this);
        }
        RapidBoardActionResult preConditionsOutcome = this.checkPreConditions();
        return preConditionsOutcome.apply(this);
    }

    public String getSupportedPlatformsUrl() {
        return this.greenHopperHelpPathResolver.getHelpPath("supported.platforms").getUrl();
    }

    public String getSidebarHtml() {
        return this.boardSidebarRenderer.getSidebarHtml(this.projectKey, this.rapidViewModel);
    }

    public boolean shouldShowSidebar() {
        return this.boardSidebarRenderer.shouldShowSidebar(this.projectKey, this.rapidViewModel);
    }

    public boolean hasCompletedFirstUseFlow() {
        ApplicationUser user = this.getLoggedInUser();
        return user != null && this.onboardingService.hasCompletedFirstUseFlow(user);
    }

    public boolean canBrowseProjects() {
        return this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, this.getLoggedInUser());
    }

    public boolean isStickySprintHeaderEnabled() {
        return !this.featureManager.isEnabled("jira.greenhopper.backlog.disableStickyHeader") && this.jiraSoftwareFeaturesService.isFeatureEnabled(JiraSoftwareFeature.STICKY_SPRINT_HEADERS);
    }

    private RapidBoardActionResult checkPreConditions() {
        if (this.agileUpgradeInProgress()) {
            return RapidBoardActionRedirect.DASHBOARD;
        }
        return RapidBoardActionView.SUCCESS;
    }

    private RapidBoardActionResult performLicenseChecks(UnlicensedAnalyticsEvent.Page requestedPage) {
        if (this.getLoggedInUser() == null) {
            return this.redirectToLogin();
        }
        if (!this.licenseService.isValidUser(this.getLoggedInUser())) {
            this.logUnlicensedAnalyticsEvent(requestedPage);
            return RapidBoardActionView.UNLICENSED;
        }
        return RapidBoardActionView.SUCCESS;
    }

    private boolean agileUpgradeInProgress() {
        return !this.upgradeVersionService.versionLooksKosher();
    }

    private RapidBoardActionResult loadModelForViewId() {
        IndexCheckService.CheckSpec checkSpec;
        IndexCheckService.CheckResult<Boolean> validateResult;
        RapidView rapidView;
        Long rapidViewId = NumberUtils.toLong(this.rapidView);
        if (this.rapidView != null) {
            rapidViewId = NumberUtils.toLong(this.rapidView);
        }
        if (rapidViewId == null) {
            rapidView = this.rapidViewHistoryService.getMostRecent(this.getLoggedInUser());
            if (rapidView == null) {
                return RapidBoardActionRedirect.MANAGE_RAPID_VIEWS;
            }
        } else {
            ServiceOutcome<RapidView> rapidViewServiceOutcome = this.rapidViewService.getRapidView(this.getLoggedInUser(), rapidViewId);
            if (rapidViewServiceOutcome.isInvalid()) {
                return RapidBoardActionView.ERROR;
            }
            rapidView = rapidViewServiceOutcome.getValue();
        }
        this.setRapidViewModel(rapidView);
        this.configureScriptPipe();
        Mode mode = this.determineMode();
        if (mode != null) {
            this.pageBuilderService.assembler().resources().requireContext(mode.getContext());
            if (this.determineDetailsView(mode)) {
                this.pageBuilderService.assembler().resources().requireContext(DETAILSVIEW_CONTEXT);
            }
        }
        if ((validateResult = this.indexCheckService.validateCheck(checkSpec = new IndexCheckService.CheckSpec().addAllCheckTypes().addRapidViews(rapidView))).isInvalid()) {
            return RapidBoardActionView.SUCCESS;
        }
        HashSet necessaryChecks = Sets.newHashSet();
        for (Map.Entry<IndexCheckService.CheckType, ServiceOutcome<Boolean>> entry : validateResult.getResults().entrySet()) {
            if (!entry.getValue().getValue().booleanValue()) continue;
            necessaryChecks.add(entry.getKey());
        }
        if (necessaryChecks.isEmpty()) {
            return RapidBoardActionView.SUCCESS;
        }
        checkSpec = new IndexCheckService.CheckSpec().addCheckTypes(necessaryChecks).addRapidViews(rapidView);
        IndexCheckService.CheckResult<Void> checkResult = this.indexCheckService.performCheck(checkSpec);
        if (checkResult.isInvalid()) {
            this.checkResults = checkResult.getResults();
            return RapidBoardActionView.INDEX_CHECKS;
        }
        return RapidBoardActionView.SUCCESS;
    }

    private void appendConfigurationDataToPage() {
        String configurationDataKey = String.format("%s:rapid-view-config", AGILE_NAMESPACE);
        Option<Jsonable> rapidViewConfigJsonable = this.rapidViewConfigDataProvider.getForRapidView(this.rapidViewModel);
        if (rapidViewConfigJsonable.isDefined()) {
            this.pageBuilderService.assembler().data().requireData(configurationDataKey, (Jsonable)rapidViewConfigJsonable.get());
        }
    }

    private RapidBoardActionResult redirectUnauthorizedUser() {
        if (this.getLoggedInUser() == null) {
            return this.redirectToLogin();
        }
        return RapidBoardActionRedirect.MANAGE_RAPID_VIEWS;
    }

    @VisibleForTesting
    RapidBoardActionResult redirectToLogin() {
        String returnURL = this.getHttpRequest().getRequestURI().substring(this.getHttpRequest().getContextPath().length()) + "?" + this.getHttpRequest().getQueryString();
        return new RapidBoardActionRedirect("/login.jsp?os_destination=" + JiraUrlCodec.encode((String)returnURL));
    }

    public List<String> getCheckTypeErrorMessages() {
        ArrayList result = Lists.newArrayList();
        for (ServiceOutcome<Void> outcome : this.getCheckResults().values()) {
            if (!outcome.isInvalid()) continue;
            result.add(StringUtils.join((Collection)this.errorCollectionTransformer.toJiraErrorCollection(outcome.getErrors()).getErrorMessages(), (String)"; "));
        }
        return result;
    }

    public String getPluginKey() {
        return "com.pyxis.greenhopper.jira";
    }

    public String getRapidView() {
        return this.rapidView;
    }

    public void setRapidView(String rapidView) {
        this.rapidView = rapidView;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public Map<IndexCheckService.CheckType, ServiceOutcome<Void>> getCheckResults() {
        return this.checkResults;
    }

    public boolean isReindexTaskRunning() {
        TaskDescriptor liveTask = this.taskManager.getLiveTask((TaskContext)new IndexTaskContext());
        if (liveTask == null) {
            return false;
        }
        return liveTask.isStarted() && !liveTask.isFinished() && !liveTask.isCancelled();
    }

    @VisibleForTesting
    void setRapidViewModel(RapidView rapidViewModel) {
        this.rapidViewModel = rapidViewModel;
        if (Strings.isNullOrEmpty((String)this.projectKey)) {
            this.trySetProjectKey();
        }
    }

    private void configureScriptPipe() {
        if (this.determineMode() != null) {
            JiraAuthenticationContextImpl.getRequestCache().put("boardPageLoadUrl", this.getPageLoadUrl());
            JiraAuthenticationContextImpl.getRequestCache().put("boardPageLoadMode", this.determineMode().getName());
        }
    }

    public String getRecentBoardsJson() {
        return this.jsonMarshaller.marshalToJSON(this.recentBoards.get());
    }

    private void trySetProjectKey() {
        Set<Project> associatedProjects;
        ApplicationUser applicationUser = this.getLoggedInUser();
        ServiceOutcome<Set<Project>> queryOutcome = this.queryService.getExplicitProjectsForRapidViewFilterQuery(applicationUser, this.rapidViewModel);
        if (queryOutcome.isValid() && (associatedProjects = queryOutcome.getValue()).size() == 1) {
            String projectKey = ((Project)Iterables.getOnlyElement(associatedProjects)).getKey();
            this.setProjectKey(projectKey);
        }
    }

    public String getLicenseErrorHtml() {
        if (this.rapidViewModel == null) {
            this.loadModelForViewId();
        }
        RequiredResources resources = this.pageBuilderService.assembler().resources();
        if (this.rapidViewModel != null) {
            this.trySetProjectKey();
            if (!Strings.isNullOrEmpty((String)this.projectKey)) {
                String projectUrl = this.insertContextPath("/projects/" + this.projectKey);
                return this.unlicensedProjectPageRenderer.render(resources, SOFTWARE_PROJECT_KEY, projectUrl);
            }
        }
        return this.unlicensedProjectPageRenderer.render(resources, SOFTWARE_PROJECT_KEY);
    }

    private void logUnlicensedAnalyticsEvent(UnlicensedAnalyticsEvent.Page requested) {
        if (requested == UnlicensedAnalyticsEvent.Page.RAPID_BOARD && this.getHttpRequest().getParameterMap().containsKey(CHART_PARAMETER)) {
            String papam = this.getHttpRequest().getParameter(CHART_PARAMETER);
            this.eventPublisher.publish((Object)new UnlicensedAnalyticsEvent(UnlicensedAnalyticsEvent.Page.REPORT, UnlicensedAnalyticsEvent.Chart.getForRequestParameter(papam)));
        } else {
            this.eventPublisher.publish((Object)new UnlicensedAnalyticsEvent(requested));
        }
    }

    private String getPageLoadUrl() {
        if (!this.featureManager.isEnabled(SoftwareFeatureFlags.DATA_ON_PAGE_LOAD) || "true".equals(this.getSingleValueParam("useStoredSettings")) || this.getSingleValueParam("rapidView") == null) {
            return null;
        }
        Set<Long> activeQuickFilters = this.getMultipleValueParam("quickFilter");
        Set<Long> activeSprints = this.getMultipleValueParam("sprint");
        Mode mode = this.determineMode();
        if (mode == null) {
            return null;
        }
        ImmutableList.Builder params = ImmutableList.builder();
        params.add((Object)("rapidViewId=" + this.rapidViewModel.getId()));
        if (activeQuickFilters.size() > 0) {
            params.add((Object)activeQuickFilters.stream().map(id -> "activeQuickFilters=" + id).collect(Collectors.joining("&")));
        }
        if (this.getProjectKey() != null) {
            params.add((Object)("selectedProjectKey=" + this.getProjectKey()));
        }
        if (activeSprints.size() > 0) {
            params.add((Object)activeSprints.stream().map(id -> "activeSprints=" + id).collect(Collectors.joining("&")));
        }
        String prefix = this.contextFactory.getJiraVelocityRequestContext().getBaseUrl() + "/rest/greenhopper/1.0/xboard";
        String queryString = Joiner.on((String)"&").join((Iterable)params.build());
        switch (mode) {
            case PLAN: {
                return String.format("%s/plan/backlog/data.json?%s", prefix, queryString);
            }
            case WORK: {
                return String.format("%s/work/allData.json?%s", prefix, queryString);
            }
        }
        return null;
    }

    private Mode determineMode() {
        String view = this.getSingleValueParam("view");
        if (view == null) {
            return Mode.WORK;
        }
        if (view.startsWith("plan")) {
            if (this.rapidViewModel.getType() == RapidView.Type.KANBAN && !this.columnService.isKanPlanEnabledForBoard(this.rapidViewModel)) {
                return Mode.WORK;
            }
            return Mode.PLAN;
        }
        if (view.startsWith("report")) {
            return Mode.REPORT;
        }
        return Mode.WORK;
    }

    private boolean determineDetailsView(Mode mode) {
        String selectedIssue = this.getSingleValueParam("selectedIssue");
        if (selectedIssue == null || !this.issueService.getIssue(this.getLoggedInUser(), selectedIssue).isValid()) {
            return false;
        }
        String view = this.getSingleValueParam("view");
        return mode == Mode.WORK && "detail".equals(view) || mode == Mode.PLAN && "planning".equals(view);
    }

    private Set<Long> getMultipleValueParam(String paramName) {
        String[] values = (String[])this.getHttpRequest().getParameterMap().get(paramName);
        return values != null ? Stream.of(values).map(Long::valueOf).collect(Collectors.toSet()) : Collections.emptySet();
    }

    private String getSingleValueParam(String paramName) {
        String[] values = (String[])this.getHttpRequest().getParameterMap().get(paramName);
        return values != null ? values[0] : null;
    }
}

