/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.service.rank.RankService;
import com.atlassian.greenhopper.service.rank.RankableFactory;
import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import org.springframework.beans.factory.annotation.Autowired;

public class RankAction
extends GreenHopperWebActionSupport {
    private Long issueId;
    @Autowired
    private IssueService issueService;
    @Autowired
    private RankService rankService;
    @Autowired
    private RankableFactory rankableFactory;
    @Autowired
    private LexoRankCustomFieldService rankCustomFieldService;

    @RequiresXsrfCheck
    public String doRankTop() {
        ApplicationUser user = this.getLoggedInApplicationUser();
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, this.issueId);
        if (!issueResult.isValid()) {
            return "error";
        }
        MutableIssue issue = issueResult.getIssue();
        this.rankService.rankFirst(user, (long)this.rankCustomFieldService.getDefaultRankField().getIdAsLong(), this.rankableFactory.fromIssue((Issue)issue));
        return this.getRedirect("/browse/" + issue.getKey());
    }

    @RequiresXsrfCheck
    public String doRankBottom() {
        ApplicationUser user = this.getLoggedInApplicationUser();
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, this.issueId);
        if (!issueResult.isValid()) {
            return "error";
        }
        MutableIssue issue = issueResult.getIssue();
        this.rankService.rankLast(user, (long)this.rankCustomFieldService.getDefaultRankField().getIdAsLong(), this.rankableFactory.fromIssue((Issue)issue));
        return this.getRedirect("/browse/" + issue.getKey());
    }

    public void setIssueId(Long issueId) {
        this.issueId = issueId;
    }
}

