/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class PageLoadDataContextProvider
implements ContextProvider {
    public static final String BOARD_PAGE_LOAD_URL_PARAM = "boardPageLoadUrl";
    public static final String BOARD_PAGE_LOAD_MODE_PARAM = "boardPageLoadMode";

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Map requestCache = JiraAuthenticationContextImpl.getRequestCache();
        String boardPageLoadUrl = (String)requestCache.get(BOARD_PAGE_LOAD_URL_PARAM);
        if (boardPageLoadUrl != null) {
            return ImmutableMap.of((Object)"requestUrl", (Object)WebUtilities.urlEncode(boardPageLoadUrl), (Object)"urlMode", requestCache.get(BOARD_PAGE_LOAD_MODE_PARAM));
        }
        return Collections.emptyMap();
    }
}

