/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.analytics.FailedKanbanTransitionAnalyticsEvent;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.AbstractIssueTransitionStrategy;
import com.atlassian.greenhopper.web.rapid.IssueTransitionAndRankService;
import com.atlassian.greenhopper.web.rapid.issue.IssueTransitions;
import com.atlassian.greenhopper.web.rapid.issue.TransitionEntry;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultipleIssueTransitionStrategy
extends AbstractIssueTransitionStrategy {
    @Autowired
    protected IssueService issueService;
    @Autowired
    private EventPublisher eventPublisher;

    @Override
    public ServiceOutcome<IssueTransitionAndRankService.TransitionAndRankResult> transitionIssues(List<Issue> issues, Column targetColumn, Integer selectedTransitionId) {
        List<Long> issueIds = issues.stream().map(Issue::getId).collect(Collectors.toList());
        if (selectedTransitionId != null) {
            return this.validateAndPerformTransitions(issueIds, issueId -> selectedTransitionId);
        }
        ServiceOutcome<List<IssueTransitions>> transitionsOutcome = this.findTransitions(issues, targetColumn);
        if (transitionsOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(transitionsOutcome);
        }
        List<IssueTransitions> issueTransitions = transitionsOutcome.get();
        String targetColumnName = this.jiraAuthenticationContext.getI18nHelper().getText(targetColumn.getName());
        if (this.isAnyIssueNotHaveTransition(issueTransitions)) {
            this.eventPublisher.publish((Object)new FailedKanbanTransitionAnalyticsEvent(this.isColumnSelectedForDevelopment(targetColumn), issues.size(), "no-available-transitions"));
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.plan.kanban.transition.multiple.issues.no.common.transition", targetColumnName);
        }
        Map<Long, List<TransitionEntry>> issueIdToTransitionsWithoutView = this.getTransitionsWithoutView(issueTransitions);
        if (this.isEachIssueHasOnlyOneTransitionWithoutView(issueIdToTransitionsWithoutView)) {
            return this.transitionIssuesHaveOneTransition(issueIds, issueIdToTransitionsWithoutView);
        }
        List<TransitionEntry> transitionIdsWithoutViewApplicableToAllIssues = this.getTransitionsApplicableToAllIssues(issueIdToTransitionsWithoutView);
        if (transitionIdsWithoutViewApplicableToAllIssues.size() == 1) {
            Integer onlyTransitionThatCanBeAppliedToAllIssues = ((TransitionEntry)Iterables.getOnlyElement(transitionIdsWithoutViewApplicableToAllIssues)).id;
            return this.validateAndPerformTransitions(issueIds, issueId -> onlyTransitionThatCanBeAppliedToAllIssues);
        }
        if (transitionIdsWithoutViewApplicableToAllIssues.size() > 1) {
            return ServiceOutcomeImpl.ok(IssueTransitionAndRankService.TransitionAndRankResult.withPossibleTransitions(transitionIdsWithoutViewApplicableToAllIssues));
        }
        if (this.isAnyTransitionHasView(issueTransitions)) {
            this.eventPublisher.publish((Object)new FailedKanbanTransitionAnalyticsEvent(this.isColumnSelectedForDevelopment(targetColumn), issues.size(), "inconsistent-view-screen-required"));
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.plan.kanban.transition.multiple.issues.transition.has.view", targetColumnName);
        }
        this.eventPublisher.publish((Object)new FailedKanbanTransitionAnalyticsEvent(this.isColumnSelectedForDevelopment(targetColumn), issues.size(), "inconsistent-multiple-transitions"));
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.plan.kanban.transition.multiple.issues.no.common.transition", targetColumnName);
    }

    private boolean isAnyIssueNotHaveTransition(List<IssueTransitions> issueTransitionsList) {
        return issueTransitionsList.stream().anyMatch(issueTransitions -> issueTransitions.transitions.isEmpty());
    }

    private Map<Long, List<TransitionEntry>> getTransitionsWithoutView(List<IssueTransitions> issueTransitions) {
        return issueTransitions.stream().collect(Collectors.toMap(it -> it.issueId, this::getTransitionsWithoutView));
    }

    private List<TransitionEntry> getTransitionsWithoutView(IssueTransitions it) {
        return it.transitions.stream().filter(transitionEntry -> !transitionEntry.hasTransitionView).collect(Collectors.toList());
    }

    private boolean isEachIssueHasOnlyOneTransitionWithoutView(Map<Long, List<TransitionEntry>> issueTransitionsList) {
        return issueTransitionsList.values().stream().allMatch(transitionEntries -> transitionEntries.size() == 1);
    }

    private List<TransitionEntry> getTransitionsApplicableToAllIssues(Map<Long, List<TransitionEntry>> issueTransitionsList) {
        return issueTransitionsList.values().stream().map(issueTransitions -> ImmutableSet.copyOf((Collection)issueTransitions)).reduce(Sets::intersection).orElse(Collections.emptySet()).stream().collect(Collectors.toList());
    }

    private boolean isAnyTransitionHasView(List<IssueTransitions> issueTransitionsList) {
        return issueTransitionsList.stream().anyMatch(issueTransitions -> issueTransitions.transitions.stream().anyMatch(transitionEntry -> transitionEntry.hasTransitionView));
    }

    private ServiceOutcome<List<IssueTransitions>> findTransitions(List<Issue> issues, Column targetColumn) {
        List transitionsOutcome = issues.stream().map(issue -> this.findApplicableTransitions((Issue)issue, targetColumn)).collect(Collectors.toList());
        ErrorCollection errorCollection = new ErrorCollection();
        transitionsOutcome.stream().filter(ServiceOutcome::isInvalid).forEach(issueTransitionsOutcome -> errorCollection.addAllErrors(issueTransitionsOutcome.getErrors()));
        if (errorCollection.hasErrors()) {
            return ServiceOutcomeImpl.from(errorCollection);
        }
        List issueTransitions = transitionsOutcome.stream().map(ServiceOutcome::get).collect(Collectors.toList());
        return ServiceOutcomeImpl.ok(issueTransitions);
    }

    private ServiceOutcome<IssueTransitionAndRankService.TransitionAndRankResult> transitionIssuesHaveOneTransition(List<Long> issueIds, Map<Long, List<TransitionEntry>> issueIdToTransitionEntries) {
        return this.validateAndPerformTransitions(issueIds, issueId -> ((TransitionEntry)Iterables.getOnlyElement((Iterable)((Iterable)issueIdToTransitionEntries.get((Object)issueId)))).id);
    }

    private ServiceOutcome<IssueTransitionAndRankService.TransitionAndRankResult> validateAndPerformTransitions(List<Long> issueIds, Function<Long, Integer> issueIdToTransitionEntries) {
        ServiceOutcome<List<IssueService.TransitionValidationResult>> validateTransitionsOutcome = this.validateIssueTransitions(issueIds, issueIdToTransitionEntries);
        if (validateTransitionsOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(validateTransitionsOutcome);
        }
        ErrorCollection errorCollection = new ErrorCollection();
        List<IssueService.TransitionValidationResult> transitionValidationResultList = validateTransitionsOutcome.get();
        transitionValidationResultList.stream().forEach(transitionValidationResult -> {
            IssueService.IssueResult issueResult = this.issueService.transition(this.jiraAuthenticationContext.getLoggedInUser(), transitionValidationResult);
            if (!issueResult.isValid()) {
                ServiceOutcome serviceOutcome = ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(transitionValidationResult.getErrorCollection());
                errorCollection.addAllErrors(serviceOutcome.getErrors());
            }
        });
        return errorCollection.hasErrors() ? ServiceOutcomeImpl.from(errorCollection) : ServiceOutcomeImpl.ok(IssueTransitionAndRankService.TransitionAndRankResult.issuesWereTransitioned());
    }

    private ServiceOutcome<List<IssueService.TransitionValidationResult>> validateIssueTransitions(List<Long> issues, Function<Long, Integer> issueIdToTransitionId) {
        ArrayList transitionValidationResultList = Lists.newArrayList();
        for (Long issueId : issues) {
            IssueService.TransitionValidationResult transitionValidationResult = this.issueService.validateTransition(this.jiraAuthenticationContext.getLoggedInUser(), issueId, issueIdToTransitionId.apply(issueId).intValue(), (IssueInputParameters)new IssueInputParametersImpl());
            if (!transitionValidationResult.isValid()) {
                return ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(transitionValidationResult.getErrorCollection());
            }
            transitionValidationResultList.add(transitionValidationResult);
        }
        return ServiceOutcomeImpl.ok(transitionValidationResultList);
    }
}

