/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.analytics.FailedKanbanTransitionAnalyticsEvent;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.web.rapid.IssueTransitionAndRankService;
import com.atlassian.greenhopper.web.rapid.IssueTransitionService;
import com.atlassian.greenhopper.web.rapid.MultipleIssueTransitionStrategy;
import com.atlassian.greenhopper.web.rapid.SingleIssueTransitionStrategy;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueTransitionServiceImpl
implements IssueTransitionService {
    @Autowired
    protected IssueHelper issueHelper;
    @Autowired
    protected JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    protected IssueService issueService;
    @Autowired
    protected PermissionManager permissionManager;
    @Autowired
    protected RapidViewService rapidViewService;
    @Autowired
    protected ColumnService columnService;
    @Autowired
    private SingleIssueTransitionStrategy singleIssueTransitionStrategy;
    @Autowired
    private MultipleIssueTransitionStrategy multipleIssueTransitionStrategy;
    @Autowired
    private EventPublisher eventPublisher;

    @Override
    public ServiceOutcome<IssueTransitionAndRankService.TransitionAndRankResult> transitionIssues(List<Issue> issues, Column targetColumn, IssueTransitionAndRankService.TransitionAndRankRequest request) {
        ServiceResult hasPermissionServiceResult = this.hasTransitionPermission(issues, request);
        if (hasPermissionServiceResult.isInvalid()) {
            return ServiceOutcomeImpl.error(hasPermissionServiceResult);
        }
        if (KanbanBacklogColumn.isKanbanBacklogColumn(targetColumn)) {
            ServiceOutcome<List<Column>> rapidViewColumnsOutcome = this.getAllColumns(request);
            if (rapidViewColumnsOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(rapidViewColumnsOutcome);
            }
            List<Column> columns = rapidViewColumnsOutcome.get();
            if (columns.size() < 2) {
                this.eventPublisher.publish((Object)new FailedKanbanTransitionAnalyticsEvent(!this.isAddToBacklog(request), issues.size(), "board-not-configured"));
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.plan.kanban.transition.board.not.configured", new Object[0]);
            }
        }
        if (!issues.isEmpty()) {
            if (issues.size() == 1) {
                return this.singleIssueTransitionStrategy.transitionIssues(issues, targetColumn, request.getSelectedTransitionId());
            }
            return this.multipleIssueTransitionStrategy.transitionIssues(issues, targetColumn, request.getSelectedTransitionId());
        }
        return ServiceOutcomeImpl.ok(IssueTransitionAndRankService.TransitionAndRankResult.withPossibleTransitions(Collections.emptyList()));
    }

    private ServiceResult hasTransitionPermission(List<Issue> issues, IssueTransitionAndRankService.TransitionAndRankRequest request) {
        boolean notHavePermission = issues.stream().anyMatch(issue -> !this.permissionManager.hasPermission(ProjectPermissions.TRANSITION_ISSUES, issue, this.jiraAuthenticationContext.getLoggedInUser()));
        if (notHavePermission) {
            this.eventPublisher.publish((Object)new FailedKanbanTransitionAnalyticsEvent(!this.isAddToBacklog(request), issues.size(), "permission-denied-transition-issue"));
            return issues.size() == 1 ? ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.boards.plan.kanban.transition.single.issue.no.transition.permission", new Object[0]) : ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.boards.plan.kanban.transition.multiple.issues.no.transition.permission", new Object[0]);
        }
        return ServiceOutcomeImpl.ok();
    }

    private boolean isAddToBacklog(IssueTransitionAndRankService.TransitionAndRankRequest request) {
        Column column = this.columnService.getColumn(request.getTargetColumn()).get();
        return KanbanBacklogColumn.isKanbanBacklogColumn(column);
    }

    private ServiceOutcome<List<Column>> getAllColumns(IssueTransitionAndRankService.TransitionAndRankRequest request) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getLoggedInUser();
        ServiceOutcome<RapidView> rapidViewOutcome = this.rapidViewService.getRapidView(currentUser, request.getRapidViewId());
        if (rapidViewOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(rapidViewOutcome);
        }
        RapidView rapidView = rapidViewOutcome.get();
        if (!this.columnService.isKanPlanEnabledForBoard(rapidView)) {
            this.eventPublisher.publish((Object)new FailedKanbanTransitionAnalyticsEvent(this.isAddToBacklog(request), request.getIssueKeys().size(), "kanplan-disabled"));
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.boards.plan.kanban.transition.issue.feature.not.enabled", new Object[0]);
        }
        List<Column> columns = this.columnService.getValidColumns(rapidViewOutcome.get());
        Preconditions.checkState((boolean)KanbanBacklogColumn.isKanbanBacklogColumn(columns.get(0)));
        return ServiceOutcomeImpl.ok(columns);
    }
}

