/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.analytics.FailedKanbanTransitionAnalyticsEvent;
import com.atlassian.greenhopper.features.SoftwareFeatureFlags;
import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.util.ServiceOutcomeHelper;
import com.atlassian.greenhopper.web.rapid.IssueRankService;
import com.atlassian.greenhopper.web.rapid.IssueTransitionAndRankService;
import com.atlassian.greenhopper.web.rapid.IssueTransitionService;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.plan.IssueTransitionDataService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Stopwatch;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueTransitionAndRankServiceImpl
implements IssueTransitionAndRankService {
    private final Logger log = Logger.getLogger(IssueTransitionAndRankService.class);
    @Autowired
    private FeatureManager featureManager;
    @Autowired
    private IssueRankService issueRankService;
    @Autowired
    private IssueHelper issueHelper;
    @Autowired
    private IssueTransitionService issueTransitionService;
    @Autowired
    EventPublisher eventPublisher;
    @Autowired
    private ColumnService columnService;
    @Autowired
    private RapidViewService rapidViewService;
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    @Autowired
    private IssueTransitionDataService issueTransitionDataService;
    @Autowired
    private ApplicationProperties applicationProperties;

    @Override
    public ServiceOutcome<IssueTransitionAndRankService.TransitionAndRankResult> transitionAndRankIssue(ApplicationUser user, IssueTransitionAndRankService.TransitionAndRankRequest request) {
        Column targetColumn = this.columnService.getColumn(request.getTargetColumn()).get();
        boolean isAddToBacklog = KanbanBacklogColumn.isKanbanBacklogColumn(targetColumn);
        if (!this.featureManager.isEnabled(SoftwareFeatureFlags.KANPLAN) && !this.featureManager.isEnabled(SoftwareFeatureFlags.OPTIMISTIC_TRANSITION)) {
            this.eventPublisher.publish((Object)new FailedKanbanTransitionAnalyticsEvent(!isAddToBacklog, request.getIssueKeys().size(), "kanplan-disabled"));
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.boards.plan.kanban.transition.issue.feature.not.enabled", new Object[0]);
        }
        if (!this.isNumberOfIssuesValid(request)) {
            this.eventPublisher.publish((Object)new FailedKanbanTransitionAnalyticsEvent(!isAddToBacklog, request.getIssueKeys().size(), "max-number-of-issues-reached", this.getMaxNumberOfTransitionedIssues()));
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.boards.plan.kanban.transition.too.much.issues", this.getMaxNumberOfTransitionedIssues());
        }
        return ServiceOutcomeHelper.toServiceOutcome(() -> {
            this.log.debug((Object)MessageFormat.format("Start transitioning and ranking {0} issue(s) for board {1}", request.getIssueKeys().size(), request.getRapidViewId()));
            List<Issue> issues = ServiceOutcomeHelper.get(this.issueHelper.findIssuesList(request.getIssueKeys()));
            Stopwatch stopwatch = Stopwatch.createStarted();
            IssueTransitionAndRankService.TransitionAndRankResult response = ServiceOutcomeHelper.get(this.issueTransitionService.transitionIssues(issues, targetColumn, request));
            stopwatch.stop();
            response.setTransitionTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            if (!response.getPossibleTransitions().isEmpty()) {
                this.log.debug((Object)MessageFormat.format("Stopped transitioning and ranking {0} issue(s) for board {1} - can't determine transition id", request.getIssueKeys().size(), request.getRapidViewId()));
                return response;
            }
            stopwatch.reset();
            stopwatch.start();
            if (request.getRankCustomFieldId() != null && (request.getRankAfterIssueIdOrKey() != null || request.getRankBeforeIssueIdOrKey() != null)) {
                ServiceOutcomeHelper.get(this.issueRankService.rankIssue(issues, request));
            }
            stopwatch.stop();
            response.setRankingTime(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            Set<Long> issueIds = issues.stream().map(Issue::getId).collect(Collectors.toSet());
            response.setUpdatedIssues(this.issueTransitionDataService.getIssueData(issueIds, request));
            if (request.isCalculateNewIssuesOrder()) {
                RapidView rapidView = ServiceOutcomeHelper.get(this.rapidViewService.getRapidView(user, request.getRapidViewId()));
                response.setNewIssuesOrder(ServiceOutcomeHelper.get(this.rapidIssueEntryQueryService.collectKanbanPlanModeIssueKeys(user, rapidView, Collections.emptySet())));
            }
            this.log.debug((Object)MessageFormat.format("Transitioning and ranking {0} issue(s) for board {1} finished successfully. Transition time: {2}ms, ranking time: {3}ms", issueIds.size(), request.getRapidViewId(), response.getTransitionTime(), response.getRankingTime()));
            return response;
        });
    }

    private int getMaxNumberOfTransitionedIssues() {
        String maxNumberOfIssuesObject = this.applicationProperties.getDefaultBackedString("jira.agile.max.number.transitioned.issues");
        return NumberUtils.toInt((String)maxNumberOfIssuesObject, (int)-1);
    }

    private boolean isNumberOfIssuesValid(IssueTransitionAndRankService.TransitionAndRankRequest transitionAndRankRequest) {
        int maxNumberOfIssues = this.getMaxNumberOfTransitionedIssues();
        return maxNumberOfIssues < 0 || transitionAndRankRequest.getIssueKeys().size() <= maxNumberOfIssues;
    }
}

