/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.rapid.issue.TransitionEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public interface IssueTransitionAndRankService {
    public static final String MAX_NUMBER_OF_TRANSITIONED_ISSUES_KEY = "jira.agile.max.number.transitioned.issues";
    public static final int DEFAULT_MAX_NUMBER_OF_TRANSITIONED_ISSUES = -1;

    public ServiceOutcome<TransitionAndRankResult> transitionAndRankIssue(ApplicationUser var1, TransitionAndRankRequest var2);

    public static class TransitionAndRankResult {
        private final boolean issuesWereTransitioned;
        private final List<TransitionEntry> possibleTransitions;
        private long transitionTime;
        private long rankingTime;
        @Nullable
        private List<String> newIssuesOrder;
        @Nullable
        private Set<RapidIssueEntry> updatedIssues;

        static TransitionAndRankResult withPossibleTransitions(List<TransitionEntry> possibleTransitions) {
            return new TransitionAndRankResult(false, possibleTransitions);
        }

        static TransitionAndRankResult issuesWereTransitioned() {
            return new TransitionAndRankResult(true, Collections.emptyList());
        }

        private TransitionAndRankResult(boolean issuesWereTransitioned, List<TransitionEntry> possibleTransitions) {
            this.issuesWereTransitioned = issuesWereTransitioned;
            this.possibleTransitions = possibleTransitions;
        }

        public boolean isIssuesWereTransitioned() {
            return this.issuesWereTransitioned;
        }

        public List<TransitionEntry> getPossibleTransitions() {
            return this.possibleTransitions;
        }

        public List<String> getNewIssuesOrder() {
            return this.newIssuesOrder;
        }

        public void setNewIssuesOrder(List<String> newIssuesOrder) {
            this.newIssuesOrder = newIssuesOrder;
        }

        public long getTransitionTime() {
            return this.transitionTime;
        }

        public void setTransitionTime(long transitionTime) {
            this.transitionTime = transitionTime;
        }

        public long getRankingTime() {
            return this.rankingTime;
        }

        public void setRankingTime(long rankingTime) {
            this.rankingTime = rankingTime;
        }

        public Set<RapidIssueEntry> getUpdatedIssues() {
            return this.updatedIssues;
        }

        public void setUpdatedIssues(Set<RapidIssueEntry> updatedIssues) {
            this.updatedIssues = updatedIssues;
        }
    }

    public static class TransitionAndRankRequest {
        private Long rapidViewId;
        private List<String> issueKeys;
        private Long targetColumn;
        private Integer selectedTransitionId;
        private Long rankCustomFieldId;
        private String rankBeforeIssueIdOrKey;
        private String rankAfterIssueIdOrKey;
        private boolean calculateNewIssuesOrder;
        private Set<Long> activeQuickFilters;

        public TransitionAndRankRequest(Long rapidViewId, List<String> issueKeys, Long targetColumn, Integer selectedTransitionId, Long rankCustomFieldId, String rankBeforeIssueIdOrKey, String rankAfterIssueIdOrKey, boolean calculateNewIssuesOrder, Set<Long> activeQuickFilters) {
            this.rapidViewId = rapidViewId;
            this.issueKeys = issueKeys;
            this.targetColumn = targetColumn;
            this.selectedTransitionId = selectedTransitionId;
            this.rankCustomFieldId = rankCustomFieldId;
            this.rankBeforeIssueIdOrKey = rankBeforeIssueIdOrKey;
            this.rankAfterIssueIdOrKey = rankAfterIssueIdOrKey;
            this.calculateNewIssuesOrder = calculateNewIssuesOrder;
            this.activeQuickFilters = activeQuickFilters;
        }

        public Long getRapidViewId() {
            return this.rapidViewId;
        }

        public List<String> getIssueKeys() {
            return this.issueKeys;
        }

        public Long getTargetColumn() {
            return this.targetColumn;
        }

        public Integer getSelectedTransitionId() {
            return this.selectedTransitionId;
        }

        public Long getRankCustomFieldId() {
            return this.rankCustomFieldId;
        }

        public String getRankBeforeIssueIdOrKey() {
            return this.rankBeforeIssueIdOrKey;
        }

        public String getRankAfterIssueIdOrKey() {
            return this.rankAfterIssueIdOrKey;
        }

        public boolean isCalculateNewIssuesOrder() {
            return this.calculateNewIssuesOrder;
        }

        public Set<Long> getActiveQuickFilters() {
            return this.activeQuickFilters;
        }
    }
}

