/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.rank.RankChangesOutcomeImpl;
import com.atlassian.greenhopper.service.rank.RankService;
import com.atlassian.greenhopper.service.rank.RankableFactory;
import com.atlassian.greenhopper.service.util.ServiceOutcomeHelper;
import com.atlassian.greenhopper.web.rapid.IssueRankService;
import com.atlassian.greenhopper.web.rapid.IssueTransitionAndRankService;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueRankServiceImpl
implements IssueRankService {
    @Autowired
    private RankService rankService;
    @Autowired
    private IssueHelper issueHelper;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private RankableFactory rankableFactory;

    @Override
    public ServiceOutcome<RankChangesOutcome> rankIssue(@Nonnull List<Issue> issues, @Nonnull IssueTransitionAndRankService.TransitionAndRankRequest request) {
        return ServiceOutcomeHelper.toServiceOutcome(() -> {
            if (request.getRankAfterIssueIdOrKey() != null) {
                Issue issue = ServiceOutcomeHelper.get(this.issueHelper.findIssue(request.getRankAfterIssueIdOrKey()));
                return ServiceOutcomeHelper.get(this.rankService.rankAfter(this.jiraAuthenticationContext.getLoggedInUser(), (long)request.getRankCustomFieldId(), this.rankableFactory.fromIssues(issues), this.rankableFactory.fromIssue(issue)));
            }
            if (request.getRankBeforeIssueIdOrKey() != null) {
                Issue issue = ServiceOutcomeHelper.get(this.issueHelper.findIssue(request.getRankBeforeIssueIdOrKey()));
                return ServiceOutcomeHelper.get(this.rankService.rankBefore(this.jiraAuthenticationContext.getLoggedInUser(), (long)request.getRankCustomFieldId(), this.rankableFactory.fromIssues(issues), this.rankableFactory.fromIssue(issue)));
            }
            return RankChangesOutcomeImpl.buildNoop();
        });
    }
}

