/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.springframework.stereotype.Service;

@Service
public class GHJSONMarshaller {
    private ObjectMapper mapper = new ObjectMapper();

    public GHJSONMarshaller() {
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        this.mapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
        this.mapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)introspector);
    }

    public String marshalToJSON(Object object) {
        try {
            StringWriter writer = new StringWriter();
            this.mapper.writeValue((Writer)writer, object);
            String json = writer.toString();
            return json.replace("/", "\\/");
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T> T unmarshalJSON(String json, Class<T> type) {
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

