/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.RapidViewNameComparator;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.greenhopper.web.rapid.RapidViewLocationResolver;
import com.atlassian.greenhopper.web.rapid.RapidViewLocationResolverFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class BoardDispatchAction
extends GreenHopperWebActionSupport {
    public static final String BOARD_SELECTOR = "boardSelector";
    @Autowired
    private ErrorCollectionTransformer errorCollectionTransformer;
    @Autowired
    private RapidViewLocationResolverFactory rapidViewLocationResolverFactory;
    private Long issueId;
    private Long sprintId;
    private Long rapidViewId;
    private Issue issue;
    private Sprint sprint;
    private List<RapidView> boards;
    private Integer numBoards;
    private ApplicationUser user;

    public String doGoToBoard() {
        this.user = this.getLoggedInApplicationUser();
        if (this.issueId != null) {
            return this._doGoToBoard(this.issueId);
        }
        if (this.sprintId != null) {
            return this._doGoToBoard(this.sprintId);
        }
        this.addErrorMessage("An issueId or sprintId must be specified", ErrorCollection.Reason.VALIDATION_FAILED);
        return "error";
    }

    public String doGoToIssueOnBoard() {
        return this.goToObjectOnBoard(this.issueId, this.rapidViewId);
    }

    public String doGoToSprintOnBoard() {
        return this.goToObjectOnBoard(this.sprintId, this.rapidViewId);
    }

    private <T> String _doGoToBoard(Long id) {
        RapidViewLocationResolver<?> resolver = this.getResolver();
        ServiceOutcome<?> object = resolver.getObject(this.user, id);
        if (!object.isValid()) {
            this.addOutcomeErrors(this.user, object);
            return "error";
        }
        if (this.isIssueRequest()) {
            this.issue = (Issue)object.getValue();
        } else {
            this.sprint = (Sprint)object.getValue();
        }
        ServiceOutcome<Set<RapidView>> outcome = resolver.getRapidViewsForObject(this.user, object.getValue());
        if (!outcome.isValid()) {
            this.addOutcomeErrors(this.user, outcome);
            return "error";
        }
        Set<RapidView> boards = outcome.getValue();
        this.numBoards = boards.size();
        if (boards.isEmpty()) {
            String error = this.isIssueRequest() ? this.getText("gh.board.dispatch.error.no.boards.for.issue") : this.getText("gh.board.dispatch.error.no.boards.for.sprint");
            this.addErrorMessage(error);
            return "error";
        }
        if (boards.size() == 1) {
            return this.goToSingleBoard(object.getValue(), resolver, boards.iterator().next().getId());
        }
        return this.goToBoardSelector(boards);
    }

    private <T> String goToSingleBoard(T object, RapidViewLocationResolver<T> resolver, Long boardId) {
        ServiceOutcome<String> urlForIssueLocation = resolver.getUrl(this.user, object, boardId);
        if (!urlForIssueLocation.isValid()) {
            this.addOutcomeErrors(this.user, urlForIssueLocation);
            return "error";
        }
        String url = urlForIssueLocation.getValue();
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(url);
        }
        return this.getRedirect(url);
    }

    private String goToBoardSelector(Set<RapidView> boards) {
        this.boards = Ordering.from((Comparator)RapidViewNameComparator.INSTANCE).sortedCopy(boards);
        return BOARD_SELECTOR;
    }

    private <T> String goToObjectOnBoard(Long id, Long rapidViewId) {
        this.user = this.getLoggedInApplicationUser();
        RapidViewLocationResolver<?> resolver = this.getResolver();
        ServiceOutcome<?> object = resolver.getObject(this.user, id);
        if (!object.isValid()) {
            this.addOutcomeErrors(this.user, object);
            return "error";
        }
        return this.goToSingleBoard(object.getValue(), resolver, rapidViewId);
    }

    private RapidViewLocationResolver<?> getResolver() {
        if (this.isIssueRequest()) {
            return this.rapidViewLocationResolverFactory.forIssue();
        }
        return this.rapidViewLocationResolverFactory.forSprint();
    }

    private void addOutcomeErrors(ApplicationUser user, ServiceOutcome<?> badOutcome) {
        this.addErrorCollection(this.errorCollectionTransformer.toJiraErrorCollection(badOutcome.getErrors(), user));
    }

    public boolean isIssueRequest() {
        return this.issueId != null;
    }

    public Long getIssueId() {
        return this.issueId;
    }

    public void setIssueId(Long issueId) {
        this.issueId = issueId;
    }

    public Long getSprintId() {
        return this.sprintId;
    }

    public void setSprintId(Long sprintId) {
        this.sprintId = sprintId;
    }

    public Long getRapidViewId() {
        return this.rapidViewId;
    }

    public void setRapidViewId(Long rapidViewId) {
        this.rapidViewId = rapidViewId;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public Sprint getSprint() {
        return this.sprint;
    }

    public List<RapidView> getBoards() {
        return this.boards;
    }

    public Integer getNumBoards() {
        return this.numBoards;
    }
}

