/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.IssueTransitionAndRankService;
import com.atlassian.greenhopper.web.rapid.issue.IssueTransitions;
import com.atlassian.greenhopper.web.rapid.issue.TransitionEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class AbstractIssueTransitionStrategy {
    @Autowired
    protected JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    protected TransitionEntryFactory transitionEntryFactory;

    public abstract ServiceOutcome<IssueTransitionAndRankService.TransitionAndRankResult> transitionIssues(List<Issue> var1, Column var2, Integer var3);

    protected ServiceOutcome<IssueTransitions> findApplicableTransitions(Issue issue, Column targetColumn) {
        ServiceOutcome<IssueTransitions> availableIssueTransitionsOutcome = this.transitionEntryFactory.buildTransitions(this.jiraAuthenticationContext.getLoggedInUser(), issue.getId());
        if (availableIssueTransitionsOutcome.isInvalid()) {
            return availableIssueTransitionsOutcome;
        }
        IssueTransitions availableIssueTransitions = availableIssueTransitionsOutcome.get();
        List applicableTransitionEntries = availableIssueTransitions.transitions.stream().filter(t -> targetColumn.getStatusIds().contains(t.targetStatus.toString())).collect(Collectors.toList());
        IssueTransitions applicableTransitions = new IssueTransitions();
        applicableTransitions.issueId = issue.getId();
        applicableTransitions.transitions = applicableTransitionEntries;
        return ServiceOutcomeImpl.ok(applicableTransitions);
    }

    public boolean isColumnSelectedForDevelopment(Column targetColumn) {
        return !KanbanBacklogColumn.isKanbanBacklogColumn(targetColumn);
    }
}

