/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rank;

import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.rank.RankService;
import com.atlassian.greenhopper.service.rank.RankableFactory;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rank.RankHelper;
import com.atlassian.greenhopper.web.rank.RankRequest;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="rank")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class RankResource
extends AbstractResource {
    RankHelper rankHelper;
    IssueService issueService;
    LexoRankCustomFieldService rankCustomFieldService;
    RankService rankService;
    RankableFactory rankableFactory;
    I18nFactoryService i18nFactoryService;

    public RankResource(RankHelper rankHelper, IssueService issueService, LexoRankCustomFieldService rankCustomFieldService, RankService rankService, RankableFactory rankableFactory, I18nFactoryService i18nFactoryService) {
        this.rankHelper = rankHelper;
        this.issueService = issueService;
        this.rankCustomFieldService = rankCustomFieldService;
        this.rankService = rankService;
        this.rankableFactory = rankableFactory;
        this.i18nFactoryService = i18nFactoryService;
    }

    @PUT
    public Response rank(RankRequest rankRequest) {
        return this.response(() -> {
            RankChangesOutcome rankChanges = this.check(this.rankHelper.rank(this.getUser(), rankRequest));
            return this.rankHelper.createRankResponse(rankChanges);
        });
    }

    @POST
    @Path(value="/global/first")
    public Response rankFirst(RankFirstLast rankFirstLast) {
        return this.response(() -> {
            ApplicationUser user = this.getUser();
            I18n2 i18n = this.i18nFactoryService.getI18n(user);
            IssueService.IssueResult issueResult = this.issueService.getIssue(user, rankFirstLast.issueId);
            if (!issueResult.isValid()) {
                ErrorCollections.checkErrors(ErrorCollection.fromJiraErrorCollection(issueResult.getErrorCollection()), i18n);
            }
            MutableIssue issue = issueResult.getIssue();
            this.check(this.rankService.rankFirst(user, (long)this.rankCustomFieldService.getDefaultRankField().getIdAsLong(), this.rankableFactory.fromIssue((Issue)issue)));
            return this.createOkResponse(RankFirstLast.from(issue));
        });
    }

    @POST
    @Path(value="/global/last")
    public Response rankLast(RankFirstLast rankFirstLast) {
        return this.response(() -> {
            ApplicationUser user = this.getUser();
            I18n2 i18n = this.i18nFactoryService.getI18n(user);
            IssueService.IssueResult issueResult = this.issueService.getIssue(user, rankFirstLast.issueId);
            if (!issueResult.isValid()) {
                ErrorCollections.checkErrors(ErrorCollection.fromJiraErrorCollection(issueResult.getErrorCollection()), i18n);
            }
            MutableIssue issue = issueResult.getIssue();
            this.check(this.rankService.rankLast(user, (long)this.rankCustomFieldService.getDefaultRankField().getIdAsLong(), this.rankableFactory.fromIssue((Issue)issue)));
            return this.createOkResponse(RankFirstLast.from(issue));
        });
    }

    @XmlRootElement
    public static class RankFirstLast
    extends RestTemplate {
        @XmlElement
        Long issueId;
        @XmlElement
        String issueKey;

        public static RankFirstLast from(MutableIssue issue) {
            RankFirstLast rankFirstLast = new RankFirstLast();
            rankFirstLast.issueId = issue.getId();
            rankFirstLast.issueKey = issue.getKey();
            return rankFirstLast;
        }
    }
}

