/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rank;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.api.rank.RankChangesOutcome;
import com.atlassian.greenhopper.api.rank.Rankable;
import com.atlassian.greenhopper.api.rank.web.RankResponse;
import com.atlassian.greenhopper.api.rank.web.RankableChange;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollections;
import com.atlassian.greenhopper.model.validation.JiraCopiedRestErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rank.RankService;
import com.atlassian.greenhopper.service.rank.RankableFactory;
import com.atlassian.greenhopper.web.rank.RankRequest;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RankHelper {
    @Autowired
    private RankService rankService;
    @Autowired
    private RankableFactory rankableFactory;
    @Autowired
    private IssueService issueService;
    @Autowired
    private JiraAuthenticationContext authenticationContext;
    @Autowired
    private I18nFactoryService i18nFactoryService;

    public ServiceOutcome<RankChangesOutcome> rank(ApplicationUser user, RankRequest rankRequest) {
        ErrorCollection errors = new ErrorCollection();
        if (rankRequest.customFieldId == null) {
            this.buildErrorAndThrow(ErrorCollection.Reason.VALIDATION_FAILED, "Rank custom field id must be specified", new Object[0]);
        }
        List<Issue> issuesToRank = rankRequest.issueKeys != null && rankRequest.issueKeys.size() > 0 ? this.getIssuesByKey(user, "issueKeys", rankRequest.issueKeys, errors) : this.getIssues(user, "issueIds", rankRequest.issueIds, errors);
        if (rankRequest.rankAfterId != null || rankRequest.rankAfterKey != null) {
            Issue rankAfter;
            Issue issue = rankAfter = rankRequest.rankAfterId != null ? this.getIssue(user, rankRequest.rankAfterId, errors) : this.getIssue(user, rankRequest.rankAfterKey, errors);
            if (errors.hasErrors()) {
                this.throwForErrors(errors);
            }
            return this.rankService.rankAfter(user, (long)rankRequest.customFieldId, this.rankableFactory.fromIssues(issuesToRank), this.rankableFactory.fromIssue(rankAfter));
        }
        if (rankRequest.rankBeforeId != null || rankRequest.rankBeforeKey != null) {
            Issue rankBefore;
            Issue issue = rankBefore = rankRequest.rankBeforeId != null ? this.getIssue(user, rankRequest.rankBeforeId, errors) : this.getIssue(user, rankRequest.rankBeforeKey, errors);
            if (errors.hasErrors()) {
                this.throwForErrors(errors);
            }
            return this.rankService.rankBefore(user, (long)rankRequest.customFieldId, this.rankableFactory.fromIssues(issuesToRank), this.rankableFactory.fromIssue(rankBefore));
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "No rank before/after issue key/id found", new Object[0]);
    }

    public Response createRankResponse(RankChangesOutcome rankChanges) {
        RankResponse rankResponse = new RankResponse();
        rankResponse.rankableChanges = new ArrayList<RankableChange>();
        for (RankChange rankChange : rankChanges.getSuccessfulRankChanges()) {
            RankableChange change = new RankableChange();
            change.issueId = rankChange.getIssueId();
            change.issueKey = this.getIssueKey(rankChange.getIssueId());
            change.wasChanged = rankChange.wasChanged();
            rankResponse.rankableChanges.add(change);
        }
        Map<Rankable, com.atlassian.jira.util.ErrorCollection> errorCollections = rankChanges.getErrorCollections();
        for (Rankable rankable : errorCollections.keySet()) {
            RankableChange change = new RankableChange();
            change.issueId = rankable.getId();
            change.issueKey = this.getIssueKey(rankable.getId());
            change.wasChanged = false;
            change.errors = Lists.newArrayList(JiraCopiedRestErrorCollection.of(errorCollections.get(rankable)).getErrorMessages());
            rankResponse.rankableChanges.add(change);
        }
        return Response.ok((Object)rankResponse).build();
    }

    private String getIssueKey(Long issueId) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, issueId);
        return issueResult.isValid() ? issueResult.getIssue().getKey() : null;
    }

    private I18n2 getI18n() {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        return loggedInUser != null ? this.i18nFactoryService.getI18n(loggedInUser) : this.i18nFactoryService.getI18n();
    }

    private List<Issue> getIssues(ApplicationUser user, String parameterName, List<Long> issueIds, ErrorCollection errors) {
        if (issueIds == null) {
            errors.addContextualError(parameterName, "Parameter is required", new Object[0]);
            return null;
        }
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Long issueId : issueIds) {
            Issue issue = this.getIssue(user, issueId, errors);
            if (issue == null) continue;
            issues.add(issue);
        }
        if (errors.hasErrors()) {
            return null;
        }
        return issues;
    }

    private List<Issue> getIssuesByKey(ApplicationUser user, String parameterName, List<String> issueKeys, ErrorCollection errors) {
        if (issueKeys == null) {
            errors.addContextualError(parameterName, "Parameter is required", new Object[0]);
            return null;
        }
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (String issueKey : issueKeys) {
            Issue issue = this.getIssue(user, issueKey, errors);
            if (issue == null) continue;
            issues.add(issue);
        }
        if (errors.hasErrors()) {
            return null;
        }
        return issues;
    }

    private Issue getIssue(ApplicationUser user, Long issueId, ErrorCollection errors) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, issueId);
        if (!issueResult.isValid()) {
            errors.addAllErrors(ErrorCollection.fromJiraErrorCollection(issueResult.getErrorCollection()));
            return null;
        }
        return issueResult.getIssue();
    }

    private Issue getIssue(ApplicationUser user, String issueKey, ErrorCollection errors) {
        IssueService.IssueResult issueResult = this.issueService.getIssue(user, issueKey);
        if (!issueResult.isValid()) {
            errors.addAllErrors(ErrorCollection.fromJiraErrorCollection(issueResult.getErrorCollection()));
            return null;
        }
        return issueResult.getIssue();
    }

    private void buildErrorAndThrow(ErrorCollection.Reason reason, String messageKey, Object ... params) {
        ErrorCollection errors = new ErrorCollection();
        errors.addError(reason, messageKey, params);
        this.throwForErrors(errors);
    }

    private void throwForErrors(ErrorCollection errors) {
        ErrorCollections.checkErrors(errors, this.getI18n());
    }
}

