/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.project;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.project.ProjectHelper;
import com.atlassian.greenhopper.web.project.ProjectModel;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import java.util.List;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="project")
@Produces(value={"application/json"})
public class ProjectResource
extends AbstractResource {
    private ProjectHelper projectHelper;

    public ProjectResource(ProjectHelper projectHelper) {
        this.projectHelper = projectHelper;
    }

    @GET
    public Response getModel() {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<List<ProjectModel>> result = ProjectResource.this.projectHelper.getAllBrowseableProjects(ProjectResource.this.getUser());
                ProjectResource.this.check(result);
                ProjectListResponse response = new ProjectListResponse();
                response.projects = result.getValue();
                return ProjectResource.this.createOkResponse(response);
            }
        });
    }

    @XmlRootElement
    public static class ProjectListResponse
    extends RestTemplate {
        @XmlElement
        public List<ProjectModel> projects;
    }
}

