/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.project;

import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.project.ProjectModel;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectHelper {
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private ProjectService projectService;

    @GET
    public com.atlassian.greenhopper.service.ServiceOutcome<List<ProjectModel>> getAllBrowseableProjects(ApplicationUser user) {
        ServiceOutcome outcome = this.projectService.getAllProjectsForAction(user, ProjectAction.VIEW_ISSUES);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.from(outcome.getErrorCollection());
        }
        ArrayList<ProjectModel> projectModels = new ArrayList<ProjectModel>();
        for (Project project : (List)outcome.getReturnedValue()) {
            if (project.isArchived()) continue;
            ProjectModel model = this.createProjectModel(project);
            projectModels.add(model);
        }
        return ServiceOutcomeImpl.ok(projectModels);
    }

    private ProjectModel createProjectModel(Project project) {
        ProjectModel model = new ProjectModel();
        model.id = project.getId();
        model.displayName = String.format("%s (%s)", project.getName(), project.getKey());
        return model;
    }

    public com.atlassian.greenhopper.service.ServiceOutcome<Project> getProject(ApplicationUser user, Long projectId) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectById(user, projectId);
        if (!projectResult.isValid()) {
            return ServiceOutcomeImpl.from(projectResult.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(projectResult.getProject());
    }

    public com.atlassian.greenhopper.service.ServiceOutcome<Project> getProjectByKey(ApplicationUser user, String projectKey) {
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return ServiceOutcomeImpl.from(projectResult.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(projectResult.getProject());
    }
}

