/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.onboarding.firstuseflow;

import com.atlassian.greenhopper.license.JiraForSoftwareChecker;
import com.atlassian.greenhopper.license.LicenseService;
import com.atlassian.jira.onboarding.FirstUseFlow;
import com.atlassian.jira.user.ApplicationUser;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultAgileFirstUseFlow
implements FirstUseFlow {
    public static final String SOFTWARE_ONBOARDING_URL = "/secure/WelcomeToJIRASoftware.jspa";
    public static final String LEGACY_AGILE_ONBOARDING_URL = "/secure/WelcomeToJiraAgile.jspa";
    private final LicenseService licenseService;
    @Autowired
    private JiraForSoftwareChecker jiraForSoftwareChecker;

    public DefaultAgileFirstUseFlow(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    public boolean isApplicable(ApplicationUser user) {
        return this.licenseService.isValidUser(user);
    }

    @Nonnull
    public String getUrl() {
        if (this.jiraForSoftwareChecker.isJiraForSoftwareSupported()) {
            return SOFTWARE_ONBOARDING_URL;
        }
        return LEGACY_AGILE_ONBOARDING_URL;
    }
}

