/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.onboarding.firstuseflow;

import com.atlassian.greenhopper.license.JiraForSoftwareChecker;
import com.atlassian.greenhopper.web.GreenHopperWebActionSupport;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import io.atlassian.fugue.Option;
import javax.servlet.http.HttpServletRequest;

public class AgileFirstUseFlowAction
extends GreenHopperWebActionSupport {
    private final PageBuilderService pageBuilderService;
    private final PluginAccessor pluginAccessor;
    private final JiraForSoftwareChecker jiraForSoftwareChecker;

    public AgileFirstUseFlowAction(PluginAccessor pluginAccessor, PageBuilderService pageBuilderService, JiraForSoftwareChecker jiraForSoftwareChecker) {
        this.pluginAccessor = pluginAccessor;
        this.pageBuilderService = pageBuilderService;
        this.jiraForSoftwareChecker = jiraForSoftwareChecker;
    }

    public String doDefault() {
        if (this.getLoggedInApplicationUser() == null) {
            return this.redirectToLogin();
        }
        this.tagRequestAsJIRASoftwareForMAU();
        Option<String> onboardingRedirection = this.updateOnboardingURL();
        if (onboardingRedirection.isDefined()) {
            return this.getRedirect((String)onboardingRedirection.get(), false);
        }
        if (this.pluginAccessor.isPluginEnabled("com.atlassian.analytics.analytics-client")) {
            this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.analytics.analytics-client:js-events");
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.pyxis.greenhopper.jira:agile-onboarding");
        return "success";
    }

    @ActionViewData
    public String getPageTitle() {
        return this.getText("onboarding.welcome.to.jira.agile");
    }

    private String redirectToLogin() {
        HttpServletRequest request = this.getHttpRequest();
        String returnURL = this.getCurrentURL();
        if (request.getQueryString() != null) {
            returnURL = returnURL + "?" + request.getQueryString();
        }
        return this.getRedirect("/login.jsp?os_destination=" + JiraUrlCodec.encode((String)returnURL), false);
    }

    private Option<String> updateOnboardingURL() {
        String expectedOnboardingURL;
        String currentURL = this.getCurrentURL();
        if (!currentURL.equals(expectedOnboardingURL = this.getExpectedOnboardingURL())) {
            return Option.some((Object)expectedOnboardingURL);
        }
        return Option.none();
    }

    private String getExpectedOnboardingURL() {
        return this.jiraForSoftwareChecker.isJiraForSoftwareSupported() ? "/secure/WelcomeToJIRASoftware.jspa" : "/secure/WelcomeToJiraAgile.jspa";
    }

    private String getCurrentURL() {
        HttpServletRequest request = this.getHttpRequest();
        return request.getRequestURI().substring(request.getContextPath().length());
    }
}

