/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.onboarding.data;

import com.atlassian.greenhopper.web.rapid.UserConfig;
import com.atlassian.greenhopper.web.rapid.UserConfigurationService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class CreateProjectSequenceData
implements WebResourceDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserConfigurationService userConfigurationService;
    private final ProjectService projectService;

    public CreateProjectSequenceData(JiraAuthenticationContext jiraAuthenticationContext, UserConfigurationService userConfigurationService, ProjectService projectService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userConfigurationService = userConfigurationService;
        this.projectService = projectService;
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                try {
                    CreateProjectSequenceData.this.getJsonData().write(writer);
                }
                catch (JSONException e) {
                    throw new Jsonable.JsonMappingException((Throwable)e);
                }
            }
        };
    }

    private JSONObject getJsonData() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        HashMap values = Maps.newHashMap();
        values.put("username", this.getUsername(user));
        values.put("canCompleteCreateProjectSequence", this.getCanCompleteCreateProjectSequence(user));
        values.put("maxKeyLength", this.projectService.getMaximumKeyLength());
        values.put("maxNameLength", this.projectService.getMaximumNameLength());
        return new JSONObject((Map)values);
    }

    private String getUsername(ApplicationUser user) {
        return user.getUsername();
    }

    public Boolean getCanCompleteCreateProjectSequence(ApplicationUser user) {
        UserConfig userConfig = this.userConfigurationService.getUserConfig(user);
        return userConfig.canCreateBoard && userConfig.canCreateProject;
    }
}

