/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.navigation;

import com.atlassian.greenhopper.web.CurrentRequestGetter;
import com.atlassian.greenhopper.web.navigation.WebItemAction;
import com.atlassian.greenhopper.web.navigation.WebItemSection;
import com.atlassian.greenhopper.web.navigation.WebSectionHelper;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebSectionHelperImpl
implements WebSectionHelper {
    @Autowired
    private CurrentRequestGetter currentRequestGetter;
    @Autowired
    private SimpleLinkManager simpleLinkManager;

    @Override
    public List<WebItemSection> getWebItemSections(ApplicationUser user, @Nonnull String webSectionLocation, @Nonnull Map<String, Object> contextParams) {
        HttpServletRequest request = this.currentRequestGetter.getCurrentRequest();
        JiraHelper helper = new JiraHelper(request, null, contextParams);
        ArrayList webItemSections = Lists.newArrayList();
        List sections = this.simpleLinkManager.getSectionsForLocation(webSectionLocation, user, helper);
        this.addAllLinks(user, helper, webItemSections, sections);
        webItemSections = Lists.newArrayList((Iterable)Iterables.filter((Iterable)webItemSections, (Predicate)new Predicate<WebItemSection>(){

            public boolean apply(@Nullable WebItemSection input) {
                return input != null && !input.actions.isEmpty();
            }
        }));
        return webItemSections;
    }

    private void addAllLinks(ApplicationUser user, JiraHelper helper, List<WebItemSection> webItemSections, List<SimpleLinkSection> sections) {
        for (SimpleLinkSection section : sections) {
            WebItemSection webItemSection = new WebItemSection();
            webItemSection.groupId = section.getId();
            webItemSections.add(webItemSection);
            List links = this.simpleLinkManager.getLinksForSection(section.getId(), user, helper);
            for (SimpleLink link : links) {
                WebItemAction action = new WebItemAction(link.getId(), link.getLabel(), link.getUrl(), link.getTitle(), link.getStyleClass());
                webItemSection.actions.add(action);
            }
            this.addAllLinks(user, helper, webItemSections, this.simpleLinkManager.getSectionsForLocation(section.getId(), user, helper));
        }
    }
}

