/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.navigation;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.rapid.RapidViewHistoryService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class RapidViewHistoryLinkFactory
implements WebItemProvider {
    @Autowired
    private RapidViewHistoryService rapidViewHistoryService;
    @Autowired
    private VelocityRequestContextFactory velocityRequestContextFactory;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private WebResourceUrlProvider webResourceUrlProvider;
    @Autowired
    private JiraAuthenticationContext authenticationContext;
    public static final int MAX_RECENT_VIEWS_TO_SHOW = 9;
    private static final String ITEM_SECTION = "greenhopper_menu/greenhopper_menu_dropdown_recent";
    private static final int WEIGHT = 85;

    public Iterable<WebItem> getItems(Map<String, Object> params) {
        ApplicationUser user = this.authenticationContext.getUser();
        List<RapidView> history = this.rapidViewHistoryService.getRecentViews(user, 9);
        if (history == null || history.isEmpty()) {
            return Collections.emptyList();
        }
        final I18n2 i18n = this.i18nFactoryService.getI18n(user);
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        final String baseUrl = requestContext.getBaseUrl();
        return Iterables.transform(history, (Function)new Function<RapidView, WebItem>(){

            public WebItem apply(RapidView rapidView) {
                String type = rapidView.isSprintSupportEnabled() ? "gh.agile.scrum" : "gh.agile.kanban";
                Long rapidViewId = rapidView.getId();
                String relativeUrl = "/secure/RapidBoard.jspa?rapidView=" + rapidViewId + "&useStoredSettings=true";
                String name = rapidView.getName();
                String id = "rapidb_lnk_" + rapidViewId;
                return new WebFragmentBuilder(id, 85).id(id).label(name).title(i18n.getText("gh.menu.recentboard.tooltip", (Object)name, (Object)i18n.getText(type))).webItem(RapidViewHistoryLinkFactory.ITEM_SECTION).url(baseUrl + relativeUrl).build();
            }
        });
    }
}

